
#include "mbed.h"
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
////////////////////Receive/////////////////////////////////////
volatile unsigned char gcs2fcs[120];
volatile unsigned int mode1,mode2;
volatile unsigned int gcs_chksum;
volatile unsigned int GainP[20],GainD[20],GainI[20];
volatile unsigned int marker_mode[20],marker_speed[20];
volatile signed long marker_latitude[20],marker_longitude[20],marker_altitude[20];
volatile double home_latitude, home_longitude, home_altitude;
volatile unsigned int gcs_button[5] = {false,false,false,false,false};
bool attitude_init,rc_init;
int poi_theta, poi_r;
void gcs_parsing(){
        gcs_chksum = 0;
        for(int i=2; i<20; i++){
            gcs_chksum += gcs2fcs[i];
        }
        if(gcs_chksum == (gcs2fcs[20]*256 + gcs2fcs[21])){
            switch(gcs2fcs[2]){
                case 0:{    // Default//
                    switch(gcs2fcs[3]){
                    case 0:{     // Home Point //
                        break;}
                    case 1: {   // Not Use ///
                        break;}
                    case 3: {       ///Button//
                            myled4 = !myled4;
                            switch(gcs2fcs[4]){
                                case 1: gcs_button[0] = !gcs_button[0]; break;
                                case 2: gcs_button[1] = !gcs_button[1]; break;
                                case 4: gcs_button[2] = !gcs_button[2]; break;
                                case 8: gcs_button[3] = !gcs_button[3]; break;
                                case 16: gcs_button[4] = !gcs_button[4]; break;   
                            }
                        break;}
                    case 4: {       //Marker//
                            myled4 = !myled4;
                            marker_mode[gcs2fcs[4]-1] = gcs2fcs[5];
                            marker_latitude[gcs2fcs[4]-1] = (gcs2fcs[9]+gcs2fcs[8]*256+gcs2fcs[7]*65536+gcs2fcs[6]*16777216)-90000000;
                            marker_longitude[gcs2fcs[4]-1] = (gcs2fcs[13]+gcs2fcs[12]*256+gcs2fcs[11]*65536+gcs2fcs[10]*16777216)-180000000;
                            marker_altitude[gcs2fcs[4]-1] = ((gcs2fcs[15]+gcs2fcs[14]*256)-10000);
                            marker_speed[gcs2fcs[4]-1] = ((gcs2fcs[17]+gcs2fcs[16]*256));
                        break;}
                    }                    
                break;}
                case 4:{    // Gain //
                    if(gcs2fcs[3] == 2){    // PID
                           GainP[gcs2fcs[4]-1] = gcs2fcs[5];
                           GainD[gcs2fcs[4]-1] = gcs2fcs[6];
                           GainI[gcs2fcs[4]-1] = gcs2fcs[7];
                    }
                    
                    break;}   
            }
        }

}
