#include "mbed.h"
#include "ROBOFRIEN_GUI.h"
#include "ROBOFRIEN_LED.h"
#include <math.h>

#define PI 3.14159265359    // This value will be used when calculating angles

Timer MainTimer;
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
ROBOFRIEN_GUI GUI;
ROBOFRIEN_LED LED;
int cnt;
int main() {
    GUI.Init();
    LED.Init();

    LED.HeadlightPeriod = GUI.headlight_period;
    LED.HeadlightDutyrate = GUI.headlight_dutyrate;
    LED.SidelightPeriod = GUI.sidelight_period;
    LED.SidelightDutyrate = GUI.sidelight_dutyrate;

    while(1) {
        GUI.pc_rx_update();
        LED.Update();
          if(GUI.rx_bool() == true){
            cnt ++;
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            //////////////////////////////////////////// [M/S] Mode and State ///////////////////////////////////////
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            GUI.Mode1 = 8 * sin( PI/180 + cnt/50.0) + 8;
            GUI.Mode2 = 8 * cos( PI/180 + cnt/50.0) + 8;
            GUI.MissionState = 8 * sin( PI/180 + cnt/50.0) + 8;
            GUI.CurrentMarker = 11 * cos( PI/180 + cnt/100.0) + 10;
            GUI.Bat1 = 50 * sin(PI/180 + cnt/50.0) + 50;   // 21.6 ~ 24.6 ( 6cell )
            GUI.Bat2 = 50 * cos(PI/180 + cnt/50.0) + 50;  // 11.1 ~ 12.6 ( 3cell )
            // [ Button State & Home Point Chksum & Marker Chksum ] is change automatically in "ROBOFRIEN_GUI.cpp" //
            // You Can not change this setting, just use it ///
            if(GUI.button[0] == true) {}
            else {}
            if(GUI.button[1] == true) {}
            else {}
            if(GUI.button[2] == true) {}
            else {}
            if(GUI.button[3] == true) {}
            else {}
            if(GUI.button[4] == true) {}
            else {}

            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            //////////////////////////////////////////////// [GPS] GPS //////////////////////////////////////////////
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            GUI.utc_time = cnt * 10;
            GUI.latitude = 35117030 + 10000 * sin( PI/180 + cnt/50.0);
            GUI.longitude = 129087896 + 10000 * cos( PI/180 + cnt/50.0);
            GUI.altitude = 22768 + 32768 * sin( PI/180 + cnt/50.0);
            GUI.SatNum = 10 + 10 * sin( PI/180 + cnt/50.0);

            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            ///////////////////////////////////////////////// AHRS //////////////////////////////////////////////////
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            GUI.rollx100 = 4500 * sin( PI/180 + cnt/50.0);
            GUI.pitchx100 = -4500 * sin( PI/180 + cnt/50.0);
            GUI.yawx100 = 18000 * sin( PI/180 + cnt/50.0) + 18000;
            GUI.roll_ratex100 =  30000 * sin( PI/180 + cnt/50.0);
            GUI.pitch_ratex100 =  30000 * sin( PI/180 + cnt/50.0 + PI/4);
            GUI.yaw_ratex100 =  30000 * sin( PI/180 + cnt/50.0 + PI*3/4);
            GUI.VXx100 = 1000 * sin(PI/180 + cnt/50.0);
            GUI.VYx100 = 1000 * cos(PI/180 + cnt/50.0);
            GUI.VZx100 = 1000 * sin(PI/180 + cnt/50.0 + PI/4);
            
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            ////////////////////////////////////////////// [C/P] CAP/PWM ////////////////////////////////////////////
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            GUI.cap[0] = 100 * sin(PI/180 + cnt/50.0);
            GUI.cap[1] = 100 * sin(PI/180 + cnt/50.0 + PI/8);
            GUI.cap[2] = 100 * sin(PI/180 + cnt/50.0 + 2*PI/8);
            GUI.cap[3] = 100 * sin(PI/180 + cnt/50.0 + 3*PI/8);
            GUI.cap[4] = 100 * sin(PI/180 + cnt/50.0 + 4*PI/8);
            GUI.cap[5] = 100 * sin(PI/180 + cnt/50.0 + 5*PI/8);
            GUI.cap[6] = 100 * sin(PI/180 + cnt/50.0 + 6*PI/8);
            GUI.cap[7] = 100 * sin(PI/180 + cnt/50.0 + 7*PI/8);
            GUI.pwm[0] = 100 * sin(PI/180 + cnt/50.0) + 100;
            GUI.pwm[1] = 100 * sin(PI/180 + cnt/50.0 + PI/8) + 100;
            GUI.pwm[2] = 100 * sin(PI/180 + cnt/50.0 + 2*PI/8) + 100;
            GUI.pwm[3] = 100 * sin(PI/180 + cnt/50.0 + 3*PI/8) + 100;
            GUI.pwm[4] = 100 * sin(PI/180 + cnt/50.0 + 4*PI/8) + 100;
            GUI.pwm[5] = 100 * sin(PI/180 + cnt/50.0 + 5*PI/8) + 100;
            GUI.pwm[6] = 100 * sin(PI/180 + cnt/50.0 + 6*PI/8) + 100;
            GUI.pwm[7] = 100 * sin(PI/180 + cnt/50.0 + 7*PI/8) + 100;
            
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            /////////////////////////////////////////// [E/D] Extra & Debug /////////////////////////////////////////
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            GUI.DEBUGx100[0] = 9000 * sin(PI/180 + cnt/50.0) + 9000;
            GUI.DEBUGx100[1] += 100;
            if(GUI.DEBUGx100[1] >= 36000) GUI.DEBUGx100[1] = 0;
            GUI.DEBUGx100[2] = 25000 * sin(PI/180 + cnt/50.0) + 25000;
            GUI.DEBUGx100[3] = 11111;
            GUI.DEBUGx100[4] = 22222;
            GUI.DEBUGx100[5] = 33333;
            GUI.DEBUGx100[6] = 44444;
            GUI.DEBUGx100[7] = 55555;

            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            /////////////////////////////////////////// Configuration ///////////////////////////////////////////////
            /////////////////////////////////////////////////////////////////////////////////////////////////////////

            ///////////////////////////// -----------------DPN 1-------------------- ////////////////////////////////
            // You can set the this value from "Config.h"  ( EEPROM_MODEL_TYPE1, EEPROM_MODEL_TYPE2_UP, EEPROM_MODEL_TYPE2_DOWN ) //

            ///////////////////////////// -----------------DPN 2-------------------- ////////////////////////////////
            // You can set the this value from "Config.h"  ( MODEL_INFO, FIRMWARE_INFO ) //

            ///////////////////////////// -----------------DPN 3-------------------- ////////////////////////////////
            /// You can set the original value of receiver to [raw_cap] with scale down ( -127 ~ 127 ) ///
            /// You can use the [cap_min[8], cap_neu[8], cap_max[8]] for calibration of RC receiver value //
            GUI.raw_cap[0] = 0;
            GUI.raw_cap[1] = 0;
            GUI.raw_cap[2] = 0;
            GUI.raw_cap[3] = 0;
            GUI.raw_cap[4] = 0;
            GUI.raw_cap[5] = 0;
            GUI.raw_cap[6] = 0;
            GUI.raw_cap[7] = 0;
                        
            ///////////////////////////// -----------------DPN 4-------------------- ////////////////////////////////
            /// You can use the [motor_min[4]] for calibration of motor pwm value //

            ///////////////////////////// -----------------DPN 5-------------------- ////////////////////////////////
            LED.HeadlightPeriod = GUI.headlight_period;
            LED.HeadlightDutyrate = GUI.headlight_dutyrate;
            LED.SidelightPeriod = GUI.sidelight_period;
            LED.SidelightDutyrate = GUI.sidelight_dutyrate;
            
            ///////////////////////////// -----------------DPN 6-------------------- ////////////////////////////////
            /// You can set the original value of receiver to [raw_cap] with scale down ( -127 ~ 127 ) ///
            /// You can use the [cap_min[8], cap_neu[8], cap_max[8]] for calibration of RC receiver value //
            if(GUI.attitude_configuration_bool == true){
                GUI.attitude_configuration_bool = false;
                // You can calibration of attitude (Roll, Pitch) //
            }
            if(GUI.Compass_Calibration_Mode == 1){
                // You can calibration of compass (Yaw)//   
            }else if(GUI.Compass_Calibration_Mode == 2){
                // You can finish the calibration of compass   
            }
            
            ///////////////////////////// -----------------DPN 7-------------------- ////////////////////////////////
            /// You can use the [limit_rollx100, limit_pitchx100, limit_roll_rate, limit_pitch_rate, limit_yaw_rate] for limit the angle and angular velocity //

            ///////////////////////////// -----------------DPN 8-------------------- ////////////////////////////////
            /// You can use the [gain_px100[20], gain_dx100[20], gain_ix100[20]] for gain tuning //

            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            //////////////////////////////////////////////// Refresh ////////////////////////////////////////////////
            /////////////////////////////////////////////////////////////////////////////////////////////////////////


            GUI.Refresh();
            
        }

    }
}
