#define eeprom_length 256


LocalFileSystem local("local");               // Create the local filesystem under the name "local"

volatile int eeprom_address[eeprom_length],eeprom_data[eeprom_length];
void eeprom_init(){
    FILE *file = fopen("/local/eeprom.txt", "r");  // Open "out.txt" on the local file system for writing    
    if(file == NULL){
        FILE *file = fopen("/local/eeprom.txt", "w");   // Write "out.txt ~~//
        for(int i=0; i<eeprom_length; i++){
            fprintf(file, "%d\t%d\r\n", i, 0);   
        }        
        fclose(file);
    }else{
        for(int i=0; i<eeprom_length; i++) {eeprom_address[i] = 0; eeprom_data[i] = 0; }
        for(int i=0; i<eeprom_length; i++){
            fscanf(file,"%d\t%d\r\n",&eeprom_address[i], &eeprom_data[i]);
        }        
    }
    fclose(file);
}

void eeprom_refresh(){
    /// Write Data to EEPROM //
    FILE *file = fopen("/local/eeprom.txt", "w");  // Open "out.txt" on the local file system for writing    
    for(int i=0; i<eeprom_length; i++){
        fprintf(file,"%d\t%d\r\n",i, eeprom_data[i]);
    }
    fclose(file);            
}

void eeprom_write(int addr, int data){
    /// Change Data //
    eeprom_data[addr] = data;
}


int eeprom_read(int addr){
    return eeprom_data[addr];    
    
}

void eeprom_reset(){
    FILE *file = fopen("/local/eeprom.txt", "w");  // Open "out.txt" on the local file system for writing    
    for(int i=0; i<256; i++){
        fprintf(file, "%d\t%d\r\n", i,0);   
    }    
    fclose(file);
}
