#pragma once

#define MODEL_INFO      "ROBOFRIEN FCC "
#define FIRMWARE_INFO 1.01

#define interrupts() sei()
#define noInterrupts() cli()
#define TO_GCS 255
#define FROM_FCS 0

#define PIN_ULTRA_TRIG A8
#define PIN_ULTRA_ECHO A9
#define AHRS_INTERRUPT_PIN A10  // use pin A10 on Arduino Uno & most boards


//// EEPROM //////
// DPN1 //
#define EEPROM_MODEL_TYPE1      0
#define EEPROM_MODEL_TYPE2_UP   1
#define EEPROM_MODEL_TYPE2_DOWN 2

// DPN3 //
#define EEPROM_RECV_MIN_1 30
#define EEPROM_RECV_MIN_2 31
#define EEPROM_RECV_MIN_3 32
#define EEPROM_RECV_MIN_4 33
#define EEPROM_RECV_MIN_5 34
#define EEPROM_RECV_MIN_6 35
#define EEPROM_RECV_MIN_7 36
#define EEPROM_RECV_MIN_8 37

#define EEPROM_RECV_NEU_1 38
#define EEPROM_RECV_NEU_2 39
#define EEPROM_RECV_NEU_3 40
#define EEPROM_RECV_NEU_4 41
#define EEPROM_RECV_NEU_5 42
#define EEPROM_RECV_NEU_6 43
#define EEPROM_RECV_NEU_7 44
#define EEPROM_RECV_NEU_8 45

#define EEPROM_RECV_MAX_1 46
#define EEPROM_RECV_MAX_2 47
#define EEPROM_RECV_MAX_3 48
#define EEPROM_RECV_MAX_4 49
#define EEPROM_RECV_MAX_5 50
#define EEPROM_RECV_MAX_6 51
#define EEPROM_RECV_MAX_7 52
#define EEPROM_RECV_MAX_8 53

// DPN 4 //
#define EEPROM_MOTOR_MIN_1_UP      54
#define EEPROM_MOTOR_MIN_1_DOWN    55
#define EEPROM_MOTOR_MIN_2_UP      56
#define EEPROM_MOTOR_MIN_2_DOWN    57
#define EEPROM_MOTOR_MIN_3_UP      58
#define EEPROM_MOTOR_MIN_3_DOWN    59
#define EEPROM_MOTOR_MIN_4_UP      60
#define EEPROM_MOTOR_MIN_4_DOWN    61
#define EEPROM_MOTOR_MIN_5_UP      62
#define EEPROM_MOTOR_MIN_5_DOWN    63
#define EEPROM_MOTOR_MIN_6_UP      64
#define EEPROM_MOTOR_MIN_6_DOWN    65
#define EEPROM_MOTOR_MIN_7_UP      66
#define EEPROM_MOTOR_MIN_7_DOWN    67
#define EEPROM_MOTOR_MIN_8_UP      68
#define EEPROM_MOTOR_MIN_8_DOWN    69

// DPN 5 //
#define EEPROM_HEADLIGHT_PERIOD     70
#define EEPROM_HEADLIGHT_DUTYRATE   71
#define EEPROM_SIDELIGHT_PERIOD     72
#define EEPROM_SIDELIGHT_DUTYRATE   73

// DPN 6 //
#define EEPROM_AHRS_ROLL_GAP_UP      74
#define EEPROM_AHRS_ROLL_GAP_DOWN    75
#define EEPROM_AHRS_PITCH_GAP_UP     76
#define EEPROM_AHRS_PITCH_GAP_DOWN   77
#define EEPROM_AHRS_YAW_GAP_UP       78
#define EEPROM_AHRS_YAW_GAP_DOWN     79


#define EEPROM_AHRS_YAW_X_GAP_1      80
#define EEPROM_AHRS_YAW_X_GAP_2      81
#define EEPROM_AHRS_YAW_Y_GAP_1      82
#define EEPROM_AHRS_YAW_Y_GAP_2      83
#define EEPROM_AHRS_YAW_Z_GAP_1      84
#define EEPROM_AHRS_YAW_Z_GAP_2      85

#define EEPROM_AHRS_DECLINATION_ANGLE_UP    86
#define EEPROM_AHRS_DECLINATION_ANGLE_DOWN  87

// DPN 7 //
#define EEPROM_LIMIT_ANGLE_ROLL_UP      88
#define EEPROM_LIMIT_ANGLE_ROLL_DOWN    89
#define EEPROM_LIMIT_ANGLE_PITCH_UP     90
#define EEPROM_LIMIT_ANGLE_PITCH_DOWN   91
#define EEPROM_LIMIT_RATE_ROLL_UP       92
#define EEPROM_LIMIT_RATE_ROLL_DOWN     93
#define EEPROM_LIMIT_RATE_PITCH_UP      94
#define EEPROM_LIMIT_RATE_PITCH_DOWN    95
#define EEPROM_LIMIT_RATE_YAW_UP        96
#define EEPROM_LIMIT_RATE_YAW_DOWN      97

// DPN 8  //
// --Gain 1 //
int EEPROM_GAIN_P_UP[20] =        {100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119};
int EEPROM_GAIN_P_DOWN[20] =      {120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139};
int EEPROM_GAIN_D_UP[20] =        {140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159};
int EEPROM_GAIN_D_DOWN[20] =      {160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179};
int EEPROM_GAIN_I_UP[20] =        {180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199};
int EEPROM_GAIN_I_DOWN[20] =      {200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219};


const int PIN_BLDC_PWM1 = 46;       // PL3 //
const int PIN_BLDC_PWM2 = 45;       // PL4 //
const int PIN_BLDC_PWM3 = 44;       // PL5 //
const int PIN_BLDC_PWM4 = 10;       // PB4 //
const int PIN_BLDC_PWM5 = 9;        // PH6 //
