#include "ROBOFRIEN_EXT_UART.h"

static Serial EXT_UART(p28,p27);

void ROBOFRIEN_EXT_UART::Init(){
    EXT_UART.baud(38400);
}

void ROBOFRIEN_EXT_UART::Refresh(){
 
 
    uint8_t Packet_SOF[2] = { 254,254 };
    uint8_t Packet_DATA[32];
    uint8_t Packet_CHKSUM[2];
    uint8_t Packet_EOF[2] = { 255,255 };

    // AHRS //
    unsigned long send_roll = roll*100 + 32767;
    Packet_DATA[0] = send_roll / 256;
    Packet_DATA[1] = send_roll % 256;
    unsigned long send_pitch = pitch*100 + 32767;
    Packet_DATA[2] = send_pitch / 256;
    Packet_DATA[3] = send_pitch % 256;
    unsigned long send_yaw = yaw*100;
    Packet_DATA[4] = send_yaw / 256;
    Packet_DATA[5] = send_yaw % 256;
    unsigned long send_want_yaw = want_yaw*100;
    Packet_DATA[6] = send_want_yaw / 256;
    Packet_DATA[7] = send_want_yaw % 256;

    // CAP and PWM //
    Packet_DATA[8] = (cap[0] + 127);
    Packet_DATA[9] = (cap[1] + 127);
    Packet_DATA[10] = (cap[2] + 127);
    Packet_DATA[11] = (cap[3] + 127);
    Packet_DATA[12] = (cap[4] + 127);
    Packet_DATA[13] = (cap[5] + 127);
    
    Packet_DATA[14] = pwm[0];
    Packet_DATA[15] = pwm[1];
    Packet_DATA[16] = pwm[2];
    Packet_DATA[17] = pwm[3];
    Packet_DATA[18] = pwm[4];
    Packet_DATA[19] = pwm[5];
    Packet_DATA[20] = pwm[6];
    Packet_DATA[21] = pwm[7];

    Packet_DATA[22] = debug[0];
    Packet_DATA[23] = debug[1];
    Packet_DATA[24] = debug[2];
    Packet_DATA[25] = debug[3];
    Packet_DATA[26] = debug[4];
    Packet_DATA[27] = debug[5];
    Packet_DATA[28] = debug[6];
    Packet_DATA[29] = debug[7];

    // CHKSUM //
    unsigned int data_checksum = 0;
    for (int i = 0; i < 30; i++) {
        data_checksum += Packet_DATA[i];
    }
    Packet_CHKSUM[0] = data_checksum / 256;
    Packet_CHKSUM[1] = data_checksum % 256;

    // Each Buffer Integrate to modem_buffer ///
    modem_buffer[0] = Packet_SOF[0];        modem_buffer[1] = Packet_SOF[1];
    for (int i = 0; i < 30; i++) {
        modem_buffer[i + 2] = Packet_DATA[i];
    }
    modem_buffer[32] = Packet_CHKSUM[0];
    modem_buffer[33] = Packet_CHKSUM[1];
    modem_buffer[34] = Packet_EOF[0];
    modem_buffer[35] = Packet_EOF[1];
 
    //// TRANS START ////
    trans_cnt = 0;
}


void ROBOFRIEN_EXT_UART::Trans(){
    
    if(trans_cnt > 35){
        
    }else{
        if(EXT_UART.writeable()){
            EXT_UART.putc(modem_buffer[trans_cnt]);
            trans_cnt ++;                           
        }
    }    
}

char uart_ID[3],uart_buffer[256];
bool uart_start_check,uart_parsing_bool;
char uart_isr_cnt;
void ROBOFRIEN_EXT_UART::Receive(){
    while (EXT_UART.readable()){
        uart_ID[1] = uart_ID[0];
        uart_ID[0] = EXT_UART.getc();
        // Check SOF //
        if ( (uart_parsing_bool == false) & ( uart_ID[1] == 254) & (uart_ID[0] == 254)){
               uart_start_check = true;
               uart_isr_cnt = 0;
        }
        else if(uart_start_check == true){
            uart_buffer[uart_isr_cnt] = uart_ID[0];
            if(uart_isr_cnt == 7){
                if( (uart_ID[0] == 255) & (uart_ID[1] == 255) ){
                    uart_parsing_bool = true;
                }else{
                    uart_parsing_bool = false;
                }
                uart_start_check = false;
            }
            uart_isr_cnt ++;
        }
    }
    /// Uart Parsing Bool ///    
    if(uart_parsing_bool == true){
        uart_parsing_bool = false;
        int cal_chksum;
        for(int i=0; i<4; i++){
            cal_chksum += uart_buffer[i];            
        }
//        if(cal_chksum == ( (unsigned int)uart_buffer[4] * 256 + uart_buffer[5] ) ){
            uart_stick_cap[0] = (signed int)uart_buffer[0]-127;
            uart_stick_cap[1] = (signed int)uart_buffer[1]-127;
            uart_stick_cap[2] = (signed int)uart_buffer[2]-127;
            uart_stick_cap[3] = (signed int)uart_buffer[3]-127;            
//        }
    }
}
