
////// 0SAS_FCC_V6 : Barometer 부착
////// 0SAS_FCC_V7 : Barometer 제거 / External UART Output 추가
////// 0SAS_FCC_V8 : PWM 최대 최소 추가, 초기 가속도 측정 wait 시간 늘리기

#include "mbed.h"
#include "MPU6050.h"
#include <math.h>
#include "ROBOFRIEN_RCV.h"
#include "ROBOFRIEN_GUI.h"
#include "ROBOFRIEN_LED.h"
#include "ROBOFRIEN_EXT_UART.h"

//#define yaw_rate_control

#define pwm_min 0.439
#define pwm_max 0.927     // pwm_min = 0.9ms, pwm_max = 1.9ms

#ifdef yaw_rate_control
#else
    #include "HMC5883L.h"
    HMC5883L hmc5883l(p9, p10);
#endif

ROBOFRIEN_EXT_UART EXT_UART;
ROBOFRIEN_GUI GUI;
ROBOFRIEN_LED LED;
ROBOFRIEN_RCV RCV1(p5);
ROBOFRIEN_RCV RCV2(p6);
ROBOFRIEN_RCV RCV3(p7);
ROBOFRIEN_RCV RCV4(p8);
ROBOFRIEN_RCV RCV5(p11);
ROBOFRIEN_RCV RCV6(p12);
MPU6050 mpu6050;           


PwmOut PWM1(p26);
PwmOut PWM2(p25);
PwmOut PWM3(p24);
PwmOut PWM4(p23);
PwmOut PWM5(p22);
PwmOut PWM6(p21);
Ticker timer_500hz; 

Timer MainTimer;
DigitalOut led2(LED2);
DigitalOut led3(LED3);

void compFilter();
void rc_cap_calibrate();
/// Setting data from Data Modem ////
int16_t limit_integral_rate_roll,limit_integral_rate_pitch,limit_integral_rate_yaw;

///////////////////////////////////////
float x, y, z, heading;
float max_m_x = 0,min_m_x = 0,max_m_y = 0,min_m_y = 0,max_m_z = 0,min_m_z = 0;
float pitchAngle = 0,rollAngle = 0,yawAngle = 0;
int16_t gyro_data[3];
float roll_rate,pitch_rate,yaw_rate;
float want_yaw;
void get_ahrs_data();
float get_compass_heading();
float complementary_roll,complementary_pitch,complementary_yaw;
float raw_mag_x, raw_mag_y, raw_mag_z;
void compass_init(){
#ifdef yaw_rate_control

#else
    raw_mag_x = hmc5883l.getMx();
    raw_mag_y = -hmc5883l.getMy();
    raw_mag_z = -hmc5883l.getMz();
    want_yaw = get_compass_heading();
    complementary_yaw = want_yaw;    
#endif
}
void ahrs_init(){
    mpu6050.whoAmI();                              // Communication test: WHO_AM_I register reading 
    mpu6050.calibrate(accelBias,gyroBias);         // Calibrate MPU6050 and load biases into bias registers
    mpu6050.init();                                // Initialize the sensor
//    timer_500hz.attach(&compFilter,    0.002);              // Call the complementaryFilter func.  every 5 ms (200 Hz sampling period)
    wait(0.5);
}

/* This function is created to avoid address error that caused from Ticker.attach func */ 
void SAS_Algorithm();
int gap_time,current_ahrs_time,ex_ahrs_time;
bool ahrs_rcv_bool;
void compFilter() {
    mpu6050.readAccelData(accelData);
    mpu6050.readGyroData(gyroData);
#ifdef yaw_rate_control

#else    
    raw_mag_x = hmc5883l.getMx();
    raw_mag_y = -hmc5883l.getMy();
    raw_mag_z = -hmc5883l.getMz();
#endif
    ex_ahrs_time = current_ahrs_time;
    current_ahrs_time = MainTimer.read_us();
    gap_time = current_ahrs_time - ex_ahrs_time;
    get_ahrs_data();
    ahrs_rcv_bool = true;
}
float get_compass_heading(){    
    float tilt_heading,no_tilt_heading;
    x = ( raw_mag_x - GUI.mag_x_avg )*0.92;
    y = ( raw_mag_y - GUI.mag_y_avg )*0.92;
    z = ( raw_mag_z - GUI.mag_z_avg  )*0.92;

    //// TILT COMPENSATION /////
    float cosRoll = cos(rollAngle*PI/180);
    float sinRoll = sin(rollAngle*PI/180);
    float cosPitch = cos(pitchAngle*PI/180);
    float sinPitch = sin(pitchAngle*PI/180);

    float Xh = x * cosRoll + y * sinPitch * sinRoll - z * cosPitch * sinRoll;
    float Yh = ( y * cosPitch + z * sinRoll ); 
//    float heading = atan2(y,x);

//    heading = atan2(Yh, Xh) - (PI/2) + declination_angle*PI/180;
//    heading = atan2(Yh, Xh) + declination_angle*PI/180;
//    heading = -atan2(y,x);
//    heading = atan2(Yh,Xh);
//    heading = atan2(y,x) + declination_angle * PI/180;
    tilt_heading = atan2(Yh,Xh) - PI / 2 + GUI.declination_angle * PI/180;
    no_tilt_heading = (atan2(y,x) - PI / 2 + GUI.declination_angle * PI/180);

    if(tilt_heading < 0) 
        tilt_heading += 2*PI;
    if(tilt_heading > 2*PI) 
        tilt_heading -= 2*PI;
    
    tilt_heading = tilt_heading * 180 / PI;
    
    if(no_tilt_heading < 0) 
        no_tilt_heading += 2*PI;
    if(no_tilt_heading > 2*PI) 
        no_tilt_heading -= 2*PI;
    
    no_tilt_heading = no_tilt_heading * 180 / PI;

    return no_tilt_heading;
}
void magnetic_offset_reset(){
    max_m_x = raw_mag_x;   
    min_m_x = raw_mag_x;   
    max_m_y = raw_mag_y;   
    min_m_y = raw_mag_y;   
    max_m_z = raw_mag_z;   
    min_m_z = raw_mag_z;
    GUI.mag_x_avg = (max_m_x + min_m_x)/2.0;
    GUI.mag_y_avg = (max_m_y + min_m_y)/2.0;
    GUI.mag_z_avg = (max_m_z + min_m_z)/2.0;
}
void magnetic_calibration(){
    /// compass min / max check //
    if( raw_mag_x > max_m_x) max_m_x = raw_mag_x;
    if( raw_mag_x < min_m_x) min_m_x = raw_mag_x;
    if( raw_mag_y > max_m_y) max_m_y = raw_mag_y;
    if( raw_mag_y < min_m_y) min_m_y = raw_mag_y;
    if( raw_mag_z > max_m_z) max_m_z = raw_mag_z;
    if( raw_mag_z < min_m_z) min_m_z = raw_mag_z;
    GUI.mag_x_avg = (max_m_x + min_m_x)/2.0;
    GUI.mag_y_avg = (max_m_y + min_m_y)/2.0;
    GUI.mag_z_avg = (max_m_z + min_m_z)/2.0;
}
float ahrs_lpf_alpha;
void get_ahrs_data(){
//    mpu6050.complementaryFilter(&rollAngle, &pitchAngle);
    /* Get actual acc value */
    mpu6050.getAres();
    ax = accelData[0]*aRes - GUI.cal_accel_bias[0];
    ay = accelData[1]*aRes - GUI.cal_accel_bias[1];
    az = accelData[2]*aRes - GUI.cal_accel_bias[2]; 

    /* Get actual gyro value */
    mpu6050.getGres();     
    roll_rate = gyroData[0]*gRes;  // - gyroBias[0];      // Results are better without extracting gyroBias[i]
    pitch_rate = -gyroData[1]*gRes;  // - gyroBias[1]; 
    yaw_rate = -gyroData[2]*gRes;  // - gyroBias[2]; 

    /* Integrate the gyro data(deg/s) over time to get angle */
    complementary_roll += roll_rate * (float)gap_time/1000000.0;  // Angle around the X-axis
    complementary_pitch +=  pitch_rate * (float)gap_time/1000000.0;  // Angle around the Y-axis
    complementary_yaw += yaw_rate * (float)gap_time/1000000.0;    // Angle around the Z-axis

    float pitchAcc, rollAcc;
//    rollAcc = atan2f(accelData[1], accelData[2])*180/PI;
//    pitchAcc  = atan2f(accelData[0], accelData[2])*180/PI;    
    rollAcc = atan2f(ay, az)*180/PI;
    pitchAcc  = atan2f(ax, az)*180/PI;    
/*  
    float forceMagnitudeApprox = sqrt( (ax*ax) + (ay*ay) + (az*az) );
    float accelerometer_factor = (2 - forceMagnitudeApprox);  // At 2G accelerometer_factor = 0 // Range = 0.0 ~ 1.0
    if(accelerometer_factor >= 1) accelerometer_factor = 1;
    else if(accelerometer_factor <= 0) accelerometer_factor = 0;
    rollAngle = rollAngle * ( 1 - accelerometer_factor / 50.0 ) + rollAcc * (accelerometer_factor / 50.0);
    pitchAngle = pitchAngle * ( 1 - accelerometer_factor / 50.0 ) + pitchAcc * (accelerometer_factor / 50.0);        
*/
    complementary_roll = complementary_roll * ahrs_lpf_alpha + rollAcc * (1-ahrs_lpf_alpha);
    complementary_pitch = complementary_pitch * ahrs_lpf_alpha + pitchAcc * (1-ahrs_lpf_alpha);        

    rollAngle = complementary_roll;// - GUI.calibrate_gap_roll;
    pitchAngle = complementary_pitch;// - GUI.calibrate_gap_pitch;

#ifdef yaw_rate_control

#else    
    /// CAL COMPASS YAW ////
    float data_yaw_to_180;
    data_yaw_to_180 = 180 - complementary_yaw;

    complementary_yaw = 180;
    float tmp_compass_heading;
    tmp_compass_heading = get_compass_heading() + data_yaw_to_180;
    if (tmp_compass_heading > 360) tmp_compass_heading -= 360;
    if (tmp_compass_heading < 0) tmp_compass_heading += 360;
    complementary_yaw = complementary_yaw*0.999 + tmp_compass_heading*0.001;
    
    complementary_yaw -= data_yaw_to_180;
#endif
    if (complementary_yaw > 360) complementary_yaw -= 360;
    if (complementary_yaw < 0) complementary_yaw += 360;

    yawAngle = complementary_yaw;    
    
}


//////////////// SAS ///////////////////
float integral_rate_roll,integral_rate_pitch,integral_rate_yaw;
int32_t error_rate_roll = 0, error_rate_pitch = 0, error_rate_yaw = 0;
int32_t derivate_lpf_roll, derivate_lpf_pitch, derivate_lpf_yaw;
void SAS_Algorithm(){
    int16_t stick_roll, stick_pitch, stick_throttle, stick_yaw;
    stick_roll = GUI.cap[0] * (GUI.limit_rollx100 / 100);        // (-100 ~ 100) to (limit angle x 100)
    stick_pitch = GUI.cap[1] * (GUI.limit_pitchx100 / 100);      // (-100 ~ 100) to (limit angle x 100)
    stick_throttle = (GUI.cap[2] + 100) * 5;                 // (-100 ~ 100) to (0 ~ 1000)
    stick_yaw = GUI.cap[3] * 45;                             // (-100 ~ 100) to (-4500 ~ 4500)

    // WANT YAW - generate //
    if( ( stick_yaw < -100 ) | ( stick_yaw > 100 ) ){
        want_yaw += (float)stick_yaw / 10000.0;
        if(want_yaw < 0) want_yaw += 360;
        if(want_yaw > 360) want_yaw -= 360;        
    }
    int16_t error_roll,error_pitch,error_yaw;
    error_roll = stick_roll - rollAngle*100;
    error_pitch = stick_pitch - pitchAngle*100;

#ifdef yaw_rate_control
    error_yaw = stick_yaw;
#else
    if(want_yaw <= 180){
        if( yawAngle <= ( 180 + want_yaw ) ) error_yaw = (want_yaw - yawAngle)*100;
        else error_yaw = ((want_yaw + 360)  - yawAngle )*100;
    }else{
        if( yawAngle >= ( want_yaw - 180 ) ) error_yaw = (want_yaw - yawAngle)*100;
        else error_yaw = (want_yaw - (yawAngle + 360))*100;
    }
#endif
    if(error_roll >= 4500) error_roll = 4500;
    else if(error_roll <= -4500) error_roll = -4500;
    if(error_pitch >= 4500) error_pitch = 4500;
    else if(error_pitch <= -4500) error_pitch = -4500;
    if(error_yaw >= 3000) error_yaw = 3000;
    else if(error_yaw <= -3000) error_yaw = -3000;
    
    /// Convert [-4500 ~ 4500] -->> [-20250 ~ 202500 degx100/s]
    int16_t earth_want_rate_roll = 0, earth_want_rate_pitch = 0, earth_want_rate_yaw = 0;
    earth_want_rate_roll = (int32_t)error_roll * GUI.gain_px100[0] / 100.0; // about -100 ~ 100
    earth_want_rate_pitch = (int32_t)error_pitch * GUI.gain_px100[2] / 100.0;
    earth_want_rate_yaw = (int32_t)error_yaw * GUI.gain_px100[4] / 100.0;
        
    int16_t body_want_rate_roll = 0, body_want_rate_pitch = 0, body_want_rate_yaw = 0;
    float sin_roll, sin_pitch, cos_roll, cos_pitch;
    sin_roll = sin((rollAngle)*PI / 180);
    sin_pitch = sin((pitchAngle)*PI / 180);
    cos_roll = cos((rollAngle)*PI / 180);
    cos_pitch = cos((pitchAngle)*PI / 180);
    body_want_rate_roll = earth_want_rate_roll - sin_pitch * earth_want_rate_yaw;
    body_want_rate_pitch = cos_roll * earth_want_rate_pitch + sin_roll * cos_pitch * earth_want_rate_yaw;
    body_want_rate_yaw = -sin_roll * earth_want_rate_pitch + cos_pitch * cos_roll * earth_want_rate_yaw;

    int32_t ex_error_rate_roll = 0, ex_error_rate_pitch = 0, ex_error_rate_yaw = 0;
    ex_error_rate_roll = error_rate_roll;
    ex_error_rate_pitch = error_rate_pitch;
    ex_error_rate_yaw = error_rate_yaw;
    error_rate_roll = ((int32_t)body_want_rate_roll - roll_rate * 100);
    error_rate_pitch = ((int32_t)body_want_rate_pitch - pitch_rate * 100);
    error_rate_yaw = ((int32_t)body_want_rate_yaw - yaw_rate * 100);
//    error_rate_roll = ((int32_t)earth_want_rate_roll - roll_rate * 100);
//    error_rate_pitch = ((int32_t)earth_want_rate_pitch - pitch_rate * 100);
//    error_rate_yaw = ((int32_t)earth_want_rate_yaw - yaw_rate * 100);

    //// RATE PID ////
    //// ---- P Gain ---- ////
    int16_t stack_roll = 0, stack_pitch = 0, stack_yaw = 0;
    stack_roll = ((float)error_rate_roll * (float)GUI.gain_px100[1] / 100.0);
    stack_pitch = ((float)error_rate_pitch * (float)GUI.gain_px100[3] / 100.0);
    stack_yaw = ((float)error_rate_yaw * (float)GUI.gain_px100[5] / 100.0);
    
    //// ---- I Gain ---- ////
    integral_rate_roll += ((float)error_rate_roll * ((float)gap_time/1000000.0) * (float)GUI.gain_ix100[1] / 100.0);
    integral_rate_pitch += ((float)error_rate_pitch * ((float)gap_time/1000000.0) * (float)GUI.gain_ix100[3] / 100.0);
    integral_rate_yaw += ((float)error_rate_yaw * ((float)gap_time/1000000.0) * (float)GUI.gain_ix100[5] / 100.0);
    if(integral_rate_roll > limit_integral_rate_roll) integral_rate_roll = limit_integral_rate_roll;
    else if(integral_rate_roll < -limit_integral_rate_roll) integral_rate_roll = -limit_integral_rate_roll;
    if(integral_rate_pitch > limit_integral_rate_pitch) integral_rate_pitch = limit_integral_rate_pitch;
    else if(integral_rate_pitch < -limit_integral_rate_pitch) integral_rate_pitch = -limit_integral_rate_pitch;
    if(integral_rate_yaw > limit_integral_rate_yaw) integral_rate_yaw = limit_integral_rate_yaw;
    else if(integral_rate_yaw < -limit_integral_rate_yaw) integral_rate_yaw = -limit_integral_rate_yaw;
    stack_roll += integral_rate_roll;
    stack_pitch += integral_rate_pitch;
    stack_yaw += integral_rate_yaw;
    
    //// ------ D Gain ----- /////
    float derivate_roll, derivate_pitch, derivate_yaw;
    derivate_roll = ((float)(error_rate_roll - ex_error_rate_roll))/((float)gap_time/1000000.0);
    derivate_pitch = ((float)(error_rate_pitch - ex_error_rate_pitch))/((float)gap_time/1000000.0);
    derivate_yaw = ((float)(error_rate_yaw - ex_error_rate_yaw))/((float)gap_time/1000000.0);
    derivate_roll = (float)derivate_roll * ((float)GUI.gain_dx100[1] / 1000.0);
    derivate_pitch = (float)derivate_pitch * ((float)GUI.gain_dx100[3] / 1000.0);
    derivate_yaw = (float)derivate_yaw * ((float)GUI.gain_dx100[5] / 1000.0);
    derivate_lpf_roll = derivate_lpf_roll * 0.9 + derivate_roll * 0.1; 
    derivate_lpf_pitch = derivate_lpf_pitch * 0.9 + derivate_pitch * 0.1; 
    derivate_lpf_yaw = derivate_lpf_yaw * 0.9 + derivate_yaw * 0.1; 
//    derivate_lpf_roll = derivate_roll;
//    derivate_lpf_pitch = derivate_pitch;
//    derivate_lpf_yaw = derivate_yaw;
    stack_roll += derivate_lpf_roll;
    stack_pitch += derivate_lpf_pitch;
    stack_yaw += derivate_lpf_yaw;
    
    /// stack limit /////
    if(stack_roll > 5000) stack_roll = 5000;
    else if(stack_roll < -5000) stack_roll = -5000;
    if(stack_pitch > 5000) stack_pitch = 5000;
    else if(stack_pitch < -5000) stack_pitch = -5000;
    if(stack_yaw > 5000) stack_yaw = 5000;
    else if(stack_yaw < -5000) stack_yaw = -5000;
    
    int16_t raw_esc_pwm[4];
    raw_esc_pwm[0] = ((float)stick_throttle * 7.5) + (+ stack_roll + stack_pitch - stack_yaw);
    raw_esc_pwm[1] = ((float)stick_throttle * 7.5) + (- stack_roll + stack_pitch + stack_yaw);
    raw_esc_pwm[2] = ((float)stick_throttle * 7.5) + (- stack_roll - stack_pitch - stack_yaw);
    raw_esc_pwm[3] = ((float)stick_throttle * 7.5) + (+ stack_roll - stack_pitch + stack_yaw);

    for (int i = 0; i < 4; i++) {
        if (raw_esc_pwm[i] > 10000) raw_esc_pwm[i] = 10000;
        else if (raw_esc_pwm[i] < 0) raw_esc_pwm[i] = 0;
    }
    uint16_t esc_pwm[4];
    for (int i = 0; i < 4; i++){
        if((stick_throttle <= 50)|(GUI.cap[4] <= -50)) {esc_pwm[i] = 0; integral_rate_roll = 0; integral_rate_pitch = 0; integral_rate_yaw = 0; want_yaw = complementary_yaw;}
        else esc_pwm[i] = raw_esc_pwm[i] + ((float)GUI.motor_min[i]*10);
    }
    
    float pwm_data[4];
    if(GUI.DPN_Info == 0){
        pwm_data[0] = (float)esc_pwm[0]/10000.0 * (pwm_max - pwm_min) + pwm_min;         // 0.439 = 0.9ms ,  0.927 = 1.9ms
        pwm_data[1] = (float)esc_pwm[1]/10000.0 * (pwm_max - pwm_min) + pwm_min;         // 0.439 = 0.9ms ,  0.927 = 1.9ms
        pwm_data[2] = (float)esc_pwm[2]/10000.0 * (pwm_max - pwm_min) + pwm_min;         // 0.439 = 0.9ms ,  0.927 = 1.9ms
        pwm_data[3] = (float)esc_pwm[3]/10000.0 * (pwm_max - pwm_min) + pwm_min;         // 0.439 = 0.9ms ,  0.927 = 1.9ms        
    }else if(GUI.DPN_Info == 4){
        pwm_data[0] = (float)GUI.pwm_info[0]/1000.0 * (pwm_max - pwm_min)  + pwm_min;   
        pwm_data[1] = (float)GUI.pwm_info[1]/1000.0 * (pwm_max - pwm_min)  + pwm_min;   
        pwm_data[2] = (float)GUI.pwm_info[2]/1000.0 * (pwm_max - pwm_min)  + pwm_min;   
        pwm_data[3] = (float)GUI.pwm_info[3]/1000.0 * (pwm_max - pwm_min)  + pwm_min;   
    }        
    // Convert [ 0 ~ 10000 ] to [ 0 ~ 200 ] //
    for (int i = 0; i < 4; i++){
         if(pwm_data[i] > pwm_max) pwm_data[i] = pwm_max;
         else if(pwm_data[i] < pwm_min) pwm_data[i] = pwm_min;
         GUI.pwm[i] = (esc_pwm[i] / 50);
    }
    PWM1 = pwm_data[0];
    PWM2 = pwm_data[1];
    PWM3 = pwm_data[2];
    PWM4 = pwm_data[3];
}


float calibrated_cap[6];
void rc_cap_calibrate(){ 
    float tmp_rcv_lpf_cap[6];
    tmp_rcv_lpf_cap[0] = (RCV1.lpf_cap[0]-150)*2;
    tmp_rcv_lpf_cap[1] = (RCV2.lpf_cap[1]-150)*2;
    tmp_rcv_lpf_cap[2] = (RCV3.lpf_cap[2]-150)*2;
    tmp_rcv_lpf_cap[3] = (RCV4.lpf_cap[3]-150)*2;
    tmp_rcv_lpf_cap[4] = (RCV5.lpf_cap[4]-150)*2;
    tmp_rcv_lpf_cap[5] = (RCV6.lpf_cap[5]-150)*2;
    for(int i=0; i<6; i++){
        if( tmp_rcv_lpf_cap[i] >= GUI.cap_neu[i] ) {
            calibrated_cap[i] = (float)(tmp_rcv_lpf_cap[i] - GUI.cap_neu[i]) * 100 / (GUI.cap_max[i] - GUI.cap_neu[i]);   
        }   
        else{
            calibrated_cap[i] = (float)(tmp_rcv_lpf_cap[i] - GUI.cap_neu[i]) * 100 / (GUI.cap_neu[i] - GUI.cap_min[i]);   
        }
        ///// MIN MAX ////
        if (calibrated_cap[i] >= 100) calibrated_cap[i] = 100;
        else if (calibrated_cap[i] <= -100) calibrated_cap[i] = -100;      
    }   
    ////// SELECT Between EXT_UART and RC Receiver /////
    GUI.cap[4] = calibrated_cap[4];            
    GUI.cap[5] = calibrated_cap[5];            
    for(int i=0; i<4; i++){
        if(GUI.cap[4] > 50){
            GUI.cap[i] = EXT_UART.uart_stick_cap[i];
        }else{            
            GUI.cap[i] = calibrated_cap[i];            
        }        
    }
}



int cnt_1hz;
int current_system_time;
int ex_millis_2ms,ex_millis_5ms,ex_millis_20ms,ex_millis_50ms,ex_millis_100ms,ex_millis_1000ms;
int ex_millis_ahrs_time;
int cnt;
uint8_t ex_Compass_Calibration_Mode;
int main() {
    /// PWM ////
    PWM1 = 0;
    PWM2 = 0;
    PWM3 = 0;
    PWM4 = 0;
    PWM1.period(0.00205);  // set PWM period to 2.05ms
    PWM2.period(0.00205);  // set PWM period to 2.05ms
    PWM3.period(0.00205);  // set PWM period to 2.05ms
    PWM4.period(0.00205);  // set PWM period to 2.05ms
    PWM1 = pwm_min;      // set duty cycle to 0.9ms 
    PWM2 = pwm_min;      // set duty cycle to 0.9ms   
    PWM3 = pwm_min;      // set duty cycle to 0.9ms   
    PWM4 = pwm_min;      // set duty cycle to 0.9ms   

    MainTimer.start();    
    GUI.Init();
    LED.Init();
    RCV1.Init();
//    RCV2.Init();
//    RCV3.Init();
//    RCV4.Init();
//    RCV5.Init();
//    RCV6.Init();
    ahrs_init();
    wait(1);
    //// Data from Data Modem ////
//    rc_cap_neu[0] = 1020; rc_cap_neu[1] = 1027; rc_cap_neu[2] = 1024; rc_cap_neu[3] = 1024; rc_cap_neu[4] = 1024; rc_cap_neu[5] = 1024; rc_cap_neu[6] = 1024; rc_cap_neu[7] = 1024;
//    rc_cap_min[0] = 352; rc_cap_min[1] = 352; rc_cap_min[2] = 352; rc_cap_min[3] = 352; rc_cap_min[4] = 352; rc_cap_min[5] = 352; rc_cap_min[6] = 352; rc_cap_min[7] = 352;
//    rc_cap_max[0] = 1696; rc_cap_max[1] = 1696; rc_cap_max[2] = 1696; rc_cap_max[3] = 1696; rc_cap_max[4] = 1696; rc_cap_max[5] = 1696; rc_cap_max[6] = 1696; rc_cap_max[7] = 1696;
//    limit_rollx100 = 4500,limit_pitchx100 = 4500;    
//    gain_px100[0] = 450; gain_px100[1] = 15; gain_ix100[1] = 10; gain_dx100[1] = 4;
//    gain_px100[2] = 450; gain_px100[3] = 15; gain_ix100[3] = 10; gain_dx100[3] = 4;
//    gain_px100[4] = 450; gain_px100[5] = 60; gain_ix100[5] = 20; gain_dx100[5] = 0;
    limit_integral_rate_roll = 500; limit_integral_rate_pitch = 500; limit_integral_rate_yaw = 500;
//    init_motor_gap[0] = 49;
//    init_motor_gap[1] = 49;
//    init_motor_gap[2] = 49;
//    init_motor_gap[3] = 49;

    led2 = 1;    
    led3 = 0;
    while(1){
        wait(0.5);
        ahrs_init();
        wait(0.005);
        compFilter();
    
        float gyro_limit = 0.3;
        if( ( gyroData[0]*gRes >= -gyro_limit ) & ( gyroData[0]*gRes <= gyro_limit ) & (gyroData[1]*gRes >= -gyro_limit ) & ( gyroData[1]*gRes <= gyro_limit ) & ( gyroData[2]*gRes >= -gyro_limit ) & ( gyroData[2]*gRes <= gyro_limit ) ){break;}
    }
    led2 = 0;
    led3 = 1;
    ahrs_lpf_alpha = 0;
    current_system_time = MainTimer.read_us();
    ex_millis_ahrs_time = current_system_time - 500;
    compFilter();

    led2 = 0;
    led3 = 0;

    ahrs_lpf_alpha = 0.997;
//    while( ( RCV1.rc_state[0] & RCV2.rc_state[1] & RCV3.rc_state[2] & RCV4.rc_state[3] & RCV5.rc_state[4] & RCV6.rc_state[5] ) == false ){
    while( ( RCV1.rc_state[0] & RCV2.rc_state[1] & RCV3.rc_state[2] & RCV4.rc_state[3] & RCV5.rc_state[4] ) == false ){
        led3 = 1;  wait(0.5);
        led3 = 0; wait(0.5);
    }
    
    compass_init();
    
    LED.HeadlightPeriod = GUI.headlight_period;
    LED.HeadlightDutyrate = GUI.headlight_dutyrate;
    LED.SidelightPeriod = GUI.sidelight_period;
    LED.SidelightDutyrate = GUI.sidelight_dutyrate;
    
    EXT_UART.Init();
    while(1) {            
        GUI.pc_rx_update();
        LED.Update();
        RCV1.Update();
        RCV2.Update();
        RCV3.Update();
        RCV4.Update();
        RCV5.Update();
        RCV6.Update();
        EXT_UART.Receive();
        EXT_UART.Trans();
        current_system_time = MainTimer.read_us();
        /// 500 Hz ///
        if(current_system_time - ex_millis_2ms >= 2000){
            ex_millis_2ms = current_system_time;
        }
        /// 200 Hz ///
        if(current_system_time - ex_millis_5ms >= 5000){
            ex_millis_5ms = current_system_time;
            compFilter();
            ex_millis_ahrs_time = current_system_time;
            SAS_Algorithm();            
        }
        /// 50 Hz ///
        if(current_system_time - ex_millis_20ms >= 20000){
            ex_millis_20ms = current_system_time;
            rc_cap_calibrate();
        }
        /// 20 Hz ///
        if(current_system_time - ex_millis_50ms >= 50000){
            ex_millis_50ms = current_system_time;
            /////// EXT UART TRANS ///////////
            EXT_UART.roll = rollAngle;
            EXT_UART.pitch = pitchAngle;
            EXT_UART.yaw = yawAngle;
            EXT_UART.want_yaw = want_yaw;
            for(int i=0; i<8; i++){
                EXT_UART.cap[i] = GUI.cap[i];                
            }              
            for(int i=0; i<8; i++){
                EXT_UART.pwm[i] = GUI.pwm[i];
            }              
            for(int i=0; i<8; i++){
                EXT_UART.debug[i] = 0;
            }               
            EXT_UART.Refresh();
        }
        /// 10 Hz ///
        if(current_system_time - ex_millis_100ms >= 100000){
            ex_millis_100ms = current_system_time;
        }
        /// 1 Hz ///
        if(current_system_time - ex_millis_1000ms >= 1000000){
            ex_millis_1000ms = current_system_time;  
//            printf("x: %f \t\ty: %f \t\t z: %f \t\t heading: %f \t\r\n", x, y, z, yawAngle);
//            printf("MAG X : %f \t\tMAG Y: %f \t\t MAG Z: %f \t\t heading: %f \t\r\n", mag_x_avg, mag_y_avg, mag_z_avg, yawAngle);
//            printf("RAW x: %f \t\tRAW y: %f \t\t RAW z: %f \t\t heading: %f \t\r\n", raw_mag_x, raw_mag_y, raw_mag_z, heading);
//            printf("MAX x: %f \t\tMAX y: %f \t\t heading: %f \t\r\n", max_m_x, max_m_y, heading);
//            printf("MIN x: %f \t\tMIN y: %f \t\t heading: %f \t\r\n", min_m_x, min_m_y, heading);
//            printf("avg x: %f \t\tavg y: %f \t\t avg z: %f \t\t heading: %f \t\r\n", avg_m_x, avg_m_y, avg_m_z, heading);
//            printf("Roll: %f \t\tPitch: %f \t\t Yaw: %f\t\r\n", rollAngle, pitchAngle, yawAngle);
        }
        
        
        
        
        /////////////////////// GUI //////////////////////////
        if(GUI.rx_bool() == true){
            cnt ++;
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            //////////////////////////////////////////// [M/S] Mode and State ///////////////////////////////////////
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            GUI.Mode1 = 8 * sin( PI/180 + cnt/50.0) + 8;
            GUI.Mode2 = 8 * cos( PI/180 + cnt/50.0) + 8;
            GUI.MissionState = 8 * sin( PI/180 + cnt/50.0) + 8;
            GUI.CurrentMarker = 11 * cos( PI/180 + cnt/100.0) + 10;
            GUI.Bat1 = 50 * sin(PI/180 + cnt/50.0) + 50;   // 21.6 ~ 24.6 ( 6cell )
            GUI.Bat2 = 50 * cos(PI/180 + cnt/50.0) + 50;  // 11.1 ~ 12.6 ( 3cell )
            // [ Button State & Home Point Chksum & Marker Chksum ] is change automatically in "ROBOFRIEN_GUI.cpp" //
            // You Can not change this setting, just use it ///
            if(GUI.button[0] == true) {}
            else {}
            if(GUI.button[1] == true) {}
            else {}
            if(GUI.button[2] == true) {}
            else {}
            if(GUI.button[3] == true) {}
            else {}
            if(GUI.button[4] == true) {}
            else {}
    
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            //////////////////////////////////////////////// [GPS] GPS //////////////////////////////////////////////
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            GUI.utc_time = cnt * 10;
            GUI.latitude = 35117030 + 10000 * sin( PI/180 + cnt/50.0);
            GUI.longitude = 129087896 + 10000 * cos( PI/180 + cnt/50.0);
            GUI.altitude = 22768 + 32768 * sin( PI/180 + cnt/50.0);
            GUI.SatNum = 10 + 10 * sin( PI/180 + cnt/50.0);
    
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            ///////////////////////////////////////////////// AHRS //////////////////////////////////////////////////
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            GUI.rollx100 = (rollAngle * 100);
            GUI.pitchx100 = (pitchAngle * 100);
            GUI.yawx100 = (yawAngle * 100);
            GUI.roll_ratex100 =  roll_rate * 100;
            GUI.pitch_ratex100 =  pitch_rate * 100;
            GUI.yaw_ratex100 =  yaw_rate * 100;
            GUI.VXx100 = 1000 * sin(PI/180 + cnt/50.0);
            GUI.VYx100 = 1000 * cos(PI/180 + cnt/50.0);
            GUI.VZx100 = 1000 * sin(PI/180 + cnt/50.0 + PI/4);
            
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            ////////////////////////////////////////////// [C/P] CAP/PWM ////////////////////////////////////////////
            /////////////////////////////////////////////////////////////////////////////////////////////////////////

            
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            /////////////////////////////////////////// [E/D] Extra & Debug /////////////////////////////////////////
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            GUI.DEBUGx100[0] = 9000 * sin(PI/180 + cnt/50.0) + 9000;
            GUI.DEBUGx100[1] += 100;
            if(GUI.DEBUGx100[1] >= 36000) GUI.DEBUGx100[1] = 0;
            GUI.DEBUGx100[2] = 25000 * sin(PI/180 + cnt/50.0) + 25000;
            GUI.DEBUGx100[2] = raw_mag_x * 100 + 180;

            
            GUI.DEBUGx100[4] = ax*100 + 10000;
            GUI.DEBUGx100[5] = ay*100 + 10000;
            GUI.DEBUGx100[6] = az*100 + 10000;
            GUI.DEBUGx100[4] = GUI.cal_accel_bias[0] * 100 + 10000;
            GUI.DEBUGx100[5] = GUI.cal_accel_bias[1] * 100 + 10000;
            GUI.DEBUGx100[6] = GUI.cal_accel_bias[2] * 100 + 10000;
            GUI.DEBUGx100[7] = MainTimer.read_us()/100000;
    
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            /////////////////////////////////////////// Configuration ///////////////////////////////////////////////
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
    
            ///////////////////////////// -----------------DPN 1-------------------- ////////////////////////////////
            // You can set the this value from "Config.h"  ( EEPROM_MODEL_TYPE1, EEPROM_MODEL_TYPE2_UP, EEPROM_MODEL_TYPE2_DOWN ) //
    
            ///////////////////////////// -----------------DPN 2-------------------- ////////////////////////////////
            // You can set the this value from "Config.h"  ( MODEL_INFO, FIRMWARE_INFO ) //
    
            ///////////////////////////// -----------------DPN 3-------------------- ////////////////////////////////
            /// You can set the original value of receiver to [raw_cap] with scale down ( -127 ~ 127 ) ///
            /// You can use the [cap_min[8], cap_neu[8], cap_max[8]] for calibration of RC receiver value //
                        
            ///////////////////////////// -----------------DPN 4-------------------- ////////////////////////////////
            /// You can use the [pwm_info , motor_min[4]] for calibration of motor pwm value //
    
            ///////////////////////////// -----------------DPN 5-------------------- ////////////////////////////////
            LED.HeadlightPeriod = GUI.headlight_period;
            LED.HeadlightDutyrate = GUI.headlight_dutyrate;
            LED.SidelightPeriod = GUI.sidelight_period;
            LED.SidelightDutyrate = GUI.sidelight_dutyrate;
            
            ///////////////////////////// -----------------DPN 6-------------------- ////////////////////////////////
            /// You can set the original value of receiver to [raw_cap] with scale down ( -127 ~ 127 ) ///
            /// You can use the [cap_min[8], cap_neu[8], cap_max[8]] for calibration of RC receiver value //
            GUI.raw_cap[0] = (RCV1.lpf_cap[0] - 150)*2;                
            GUI.raw_cap[1] = (RCV2.lpf_cap[1] - 150)*2;                
            GUI.raw_cap[2] = (RCV3.lpf_cap[2] - 150)*2;                
            GUI.raw_cap[3] = (RCV4.lpf_cap[3] - 150)*2;                
            GUI.raw_cap[4] = (RCV5.lpf_cap[4] - 150)*2;                
            GUI.raw_cap[5] = (RCV6.lpf_cap[5] - 150)*2;                
            GUI.raw_cap[6] = 0;
            GUI.raw_cap[7] = 0;

            if(GUI.attitude_configuration_bool == true){
                GUI.attitude_configuration_bool = false;
                // You can calibration of attitude (Roll, Pitch) //
                GUI.attitude_calibrate(accelData[0]*aRes,accelData[1]*aRes,(accelData[2]*aRes-1));   
            }
            if(GUI.Compass_Calibration_Mode == 1){
                // You can calibration of compass (Yaw)//   
                if(ex_Compass_Calibration_Mode == 0){
                    magnetic_offset_reset();                    
                }else{
                    //// calibrating ... /////
                    magnetic_calibration();                    
                }
            }else if(GUI.Compass_Calibration_Mode == 2){
                // You can finish the calibration of compass   
                //// write to eeprom ////
                GUI.Compass_Calibration_Mode = 0;
                GUI.write_compass_setting_to_eeprom();     
            }
            ex_Compass_Calibration_Mode = GUI.Compass_Calibration_Mode;
            
            ///////////////////////////// -----------------DPN 7-------------------- ////////////////////////////////
            /// You can use the [limit_rollx100, limit_pitchx100, limit_roll_rate, limit_pitch_rate, limit_yaw_rate] for limit the angle and angular velocity //
    
            ///////////////////////////// -----------------DPN 8-------------------- ////////////////////////////////
            /// You can use the [gain_px100[20], gain_dx100[20], gain_ix100[20]] for gain tuning //
    
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            //////////////////////////////////////////////// Refresh ////////////////////////////////////////////////
            /////////////////////////////////////////////////////////////////////////////////////////////////////////
            GUI.Refresh();
        }
        
        ////////////////////////////////////////////////////////////////////////////////////
    }
}





