#include "ROBOFRIEN_LED.h"

Timer LedTimer;
DigitalOut myled1(LED1);
DigitalOut myled4(LED4);

void ROBOFRIEN_LED::Init(){
    LedTimer.start();
    myled1 = 0;
    myled4 = 0;
}

int ex_headlight_timer, ex_sidelight_timer;
void ROBOFRIEN_LED::Update(){
    //// LED - HEAD LIGHT ///
    if( (HeadlightPeriod == 0) | (HeadlightDutyrate == 0) ){
        myled1 = 0;
    }else{
        if( (ex_headlight_timer +  ((int)HeadlightPeriod * 100) ) >=  LedTimer.read_ms() ){
            if( (ex_headlight_timer + (float)((int)HeadlightPeriod * 100) * ((float)HeadlightDutyrate / 100.0) ) >= LedTimer.read_ms() ){
                myled1 = 1;   
            }else{
                myled1 = 0;
            }
        }else{
            ex_headlight_timer = LedTimer.read_ms();
        }            
    } 
    //// LED - SIDE LIGHT ///
    if( (SidelightPeriod == 0) | (SidelightDutyrate == 0) ){
        myled4 = 0;        
    }else{
        if( (ex_sidelight_timer +  ((int)SidelightPeriod * 100) ) >=  LedTimer.read_ms() ){
            if( (ex_sidelight_timer + (float)((int)SidelightPeriod * 100) * ((float)SidelightDutyrate / 100.0) ) >= LedTimer.read_ms() ){
                myled4 = 1;   
            }else{
                myled4 = 0;
            }
        }else{
            ex_sidelight_timer = LedTimer.read_ms();
        }            
    }
    
    /////////// RESET //////////////
    if( LedTimer.read_ms() > 1000000000){
        ex_headlight_timer = 0;
        ex_sidelight_timer = 0;
        LedTimer.reset();   
    }

}
