#include "ROBOFRIEN_SBUS.h"
#include "millis.h"
#include "BufferedSerial.h"

BufferedSerial SBUS_(p13,p14);

#define CAP_MIN     487
#define CAP_NEU     1024
#define CAP_MAX     1561
bool reverse_bool[16] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

void ROBOFRIEN_SBUS::Init(){
    SBUS_.baud(100000);
    SBUS_.format(8, Serial::Even, 2);
    CONTROLLER_STATE = SIGNAL_OFF;
}

uint8_t BIT_REVERSE(uint8_t INPUT){
    uint8_t OUTPUT;
    OUTPUT = INPUT << 7;
    OUTPUT |= ( ((INPUT >> 1)&0b00000001) << 6 ); 
    OUTPUT |= ( ((INPUT >> 2)&0b00000001) << 5 ); 
    OUTPUT |= ( ((INPUT >> 3)&0b00000001) << 4 ); 
    OUTPUT |= ( ((INPUT >> 4)&0b00000001) << 3 ); 
    OUTPUT |= ( ((INPUT >> 5)&0b00000001) << 2 ); 
    OUTPUT |= ( ((INPUT >> 6)&0b00000001) << 1 ); 
    OUTPUT |= ( ((INPUT >> 7)&0b00000001) << 0 ); 
    return OUTPUT;
}
uint16_t BIT11_REVERSE(uint16_t INPUT){
    uint16_t OUTPUT;
    INPUT = INPUT & 0b0000011111111111;
    OUTPUT = INPUT << 10;
    OUTPUT |= ( ((INPUT >> 1)&0b0000000000000001) << 9 ); 
    OUTPUT |= ( ((INPUT >> 2)&0b0000000000000001) << 8 ); 
    OUTPUT |= ( ((INPUT >> 3)&0b0000000000000001) << 7 ); 
    OUTPUT |= ( ((INPUT >> 4)&0b0000000000000001) << 6 ); 
    OUTPUT |= ( ((INPUT >> 5)&0b0000000000000001) << 5 ); 
    OUTPUT |= ( ((INPUT >> 6)&0b0000000000000001) << 4 ); 
    OUTPUT |= ( ((INPUT >> 7)&0b0000000000000001) << 3 ); 
    OUTPUT |= ( ((INPUT >> 8)&0b0000000000000001) << 2 ); 
    OUTPUT |= ( ((INPUT >> 9)&0b0000000000000001) << 1 ); 
    OUTPUT |= ( ((INPUT >>10)&0b0000000000000001) << 0 ); 
    OUTPUT = OUTPUT & 0b0000011111111111;
    return OUTPUT;
    
}

void ROBOFRIEN_SBUS::update(){
    while( SBUS_.readable() > 0){
        SBUS_ID[2] = SBUS_ID[1];
        SBUS_ID[1] = SBUS_ID[0];
        SBUS_ID[0] = BIT_REVERSE(SBUS_.getc());
        SBUS_CNT ++;
        if( start_bool == false ){
            if( ( SBUS_ID[1] == 0b00000000 ) & ( SBUS_ID[0] == 0b11110000 ) ){
                start_bool = true;
                check_cnt = SBUS_CNT;
                SBUS_CNT = 0;
            }            
        }else{
            SBUS_BUFF[SBUS_CNT] = SBUS_ID[0];
            if(SBUS_CNT == 24){
                start_bool = false;
                channel[ 0]  = ( (uint16_t)(SBUS_BUFF[ 1]&0b11111111)<<3 | (uint16_t)((uint16_t)SBUS_BUFF[ 2]&0b11100000)>>5 );
                channel[ 1]  = ( (int16_t)(SBUS_BUFF[ 2]&0b00011111)<<6 | (int16_t)(SBUS_BUFF[ 3]&0b11111100)>>2 );
                channel[ 2]  = ( (int16_t)(SBUS_BUFF[ 3]&0b00000011)<<9 | (int16_t)(SBUS_BUFF[ 4]&0b11111111)<<1 | (int16_t)(SBUS_BUFF[5]&0b10000000)>>7 );
                channel[ 3]  = ( (int16_t)(SBUS_BUFF[ 5]&0b01111111)<<4 | (int16_t)(SBUS_BUFF[ 6]&0b11110000)>>4 );
                channel[ 4]  = ( (int16_t)(SBUS_BUFF[ 6]&0b00001111)<<7 | (int16_t)(SBUS_BUFF[ 7]&0b11111110)>>1 );
                channel[ 5]  = ( (int16_t)(SBUS_BUFF[ 7]&0b00000001)<<10| (int16_t)(SBUS_BUFF[ 8]&0b11111111)<<2 | (int16_t)(SBUS_BUFF[9]&0b11000000)>>6 );
                channel[ 6]  = ( (int16_t)(SBUS_BUFF[ 9]&0b00111111)<<5 | (int16_t)(SBUS_BUFF[10]&0b11111000)>>3 );
                channel[ 7]  = ( (int16_t)(SBUS_BUFF[10]&0b00000111)<<8 | (int16_t)(SBUS_BUFF[11]&0b11111111)>>0 );
                channel[ 8]  = ( (int16_t)(SBUS_BUFF[11]&0b11111111)<<3 | (int16_t)(SBUS_BUFF[12]&0b11100000)>>5 );
                channel[ 9]  = ( (int16_t)(SBUS_BUFF[12]&0b00011111)<<6 | (int16_t)(SBUS_BUFF[13]&0b11111100)>>2 );
                channel[10]  = ( (int16_t)(SBUS_BUFF[13]&0b00000011)<<9 | (int16_t)(SBUS_BUFF[14]&0b11111111)<<1 | (int16_t)(SBUS_BUFF[15]&0b10000000)>>7 );
                channel[11]  = ( (int16_t)(SBUS_BUFF[15]&0b01111111)<<4 | (int16_t)(SBUS_BUFF[16]&0b11110000)>>4 );
                channel[12]  = ( (int16_t)(SBUS_BUFF[16]&0b00001111)<<7 | (int16_t)(SBUS_BUFF[17]&0b11111110)>>1 );
                channel[13]  = ( (int16_t)(SBUS_BUFF[17]&0b00000001)<<10| (int16_t)(SBUS_BUFF[18]&0b11111111)<<2 | (int16_t)(SBUS_BUFF[19]&0b11000000)>>6 );
                channel[14]  = ( (int16_t)(SBUS_BUFF[19]&0b00111111)<<5 | (int16_t)(SBUS_BUFF[20]&0b11111000)>>3 );
                channel[15]  = ( (int16_t)(SBUS_BUFF[20]&0b00000111)<<8 | (int16_t)(SBUS_BUFF[21]&0b11111111)>>0 );
                for(int i=0; i<16; i++){
                    channel[ i]  = BIT11_REVERSE(channel[ i]);
                    if( channel[i] < CAP_MIN ) channel[i] = CAP_MIN;
                    else if( channel[i] > CAP_MAX ) channel[i] = CAP_MAX;
                    channel[i] = (channel[i] - 1024) * 1000 / 537.0;
                    // 487, 1024, 1561 //  RANGE : -1000 ~ 1000
                }
                if( channel[4] < -500 ){            // Motor OFF
                    CONTROLLER_STATE = MOTOR_OFF;
                }else if( channel[4] < 500) {       // Manual Mode
                    if( channel[7] < -500){         // Manual - Attitude Mode
                        if( channel[2] < -950){
                            CONTROLLER_STATE = MOTOR_OFF;
                        }else{
                            CONTROLLER_STATE = MANUAL_ATTITUDE;                            
                        }
                    }else if( channel[7] < 500){    // Manual - Velocity Mode
                        CONTROLLER_STATE = MANUAL_VELOCITY;  
                    }else{                          // Manual - Position Mode
                        CONTROLLER_STATE = MANUAL_POSITION;                          
                    }
                }else{                              // Auto Flight Mode
                    CONTROLLER_STATE = AUTO_FLIGHT;                                                                      
                    if( channel[ 5] < -500){
                        HOMEPOINT_BOOL = false;
                    }else if( channel[ 5] > 500){
                        HOMEPOINT_BOOL = true;
                    }else{
                        HOMEPOINT_BOOL = false;
                    }
                }
            }
        }
    }
}
