#include "ROBOFRIEN_LED.h"
#include "millis.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

void ROBOFRIEN_LED::Init(){
    myled1 = 0;
    myled2 = 0;
    myled3 = 0;
    myled4 = 0;
}
void ROBOFRIEN_LED::ALARM(uint8_t ALARM_DATA){
    switch(ALARM_DATA){
        case 0:{        // NORMAL
            myled2 = 0;
            myled3 = 0;
        }break;
        case 1:{        // ALARM1
            myled2 = 1;
            myled3 = 0;            
        }break;
        case 2:{        // ALARM2
            myled2 = 0;
            myled3 = 1;            
        }break;
        case 3:{        // ALARM3
            myled2 = 1;
            myled3 = 1;            
        }break;
    }
}
int headlight_millis, sidelight_millis;
void ROBOFRIEN_LED::update(uint8_t HD_PD, uint8_t HD_DR, uint8_t SD_PD, uint8_t SD_DR){
    //////// HEAD LIGHT /////////////
    if( ( millis() - headlight_millis ) < (HD_PD*100*HD_DR/100.0) ){
        myled1 = 1;
    }
    else if( ( millis() - headlight_millis ) < (HD_PD*100) ){
        myled1 = 0;
    }else{
        headlight_millis = millis();        
    }


    //////// SIDE LIGHT /////////////
    if( ( millis() - sidelight_millis ) < (SD_PD*100*SD_DR/100.0) ){
        myled4 = 1;
    }
    else if( ( millis() - sidelight_millis ) < (SD_PD*100) ){
        myled4 = 0;
    }else{
        sidelight_millis = millis();        
    }

}
