#include "ROBOFRIEN_BAT.h"

AnalogIn        BAT_ANALOG(A0);

#define BAT_1CELL_MIN       3.8
#define BAT_1CELL_MAX       4.1
#define DC_DC_REFERENCE     3.3
#define REGISTER_RATIO      11
#define BAT_LPF             0.9

void ROBOFRIEN_BAT::Init(int cell_info){
    BAT_MIN = BAT_1CELL_MIN * cell_info;
    BAT_MAX = BAT_1CELL_MAX * cell_info;
}

float ROBOFRIEN_BAT::update(){
    float BAT_PERCENT = 0;
    ORIGIN_DATA = BAT_ANALOG;
    BAT_PERCENT = ((BAT_ANALOG*DC_DC_REFERENCE*REGISTER_RATIO)-BAT_MIN)/(BAT_MAX-BAT_MIN)*100;
    LPF_BAT_DATA = LPF_BAT_DATA * BAT_LPF + BAT_PERCENT * (1-BAT_LPF);
    return BAT_PERCENT;
}
