#include "ROBOFRIEN_MOTOR.h"

float PWM_MIN = 1/3.0f;
float PWM_MAX = 2/3.0f;

PwmOut  pwm1(p21);
PwmOut  pwm2(p22);
PwmOut  pwm3(p23);
PwmOut  pwm4(p24);
PwmOut  pwm5(p25);
PwmOut  pwm6(p26);

void ROBOFRIEN_MOTOR::OFF(){
    pwm1.write(PWM_MIN);
    pwm2.write(PWM_MIN);
    pwm3.write(PWM_MIN);
    pwm4.write(PWM_MIN);
    pwm5.write(PWM_MIN);
    pwm6.write(PWM_MIN);    
}

void ROBOFRIEN_MOTOR::Init(){
    pwm1.period(0.003f);     // 3 ms
    pwm2.period(0.003f);     // 3 ms
    pwm3.period(0.003f);     // 3 ms
    pwm4.period(0.003f);     // 3 ms
    pwm5.period(0.003f);     // 3 ms
    pwm6.period(0.003f);     // 3 ms
    OFF();
}

void ROBOFRIEN_MOTOR::update(){        
    /* ***** */
    // 1ms = 1/3;
    // 2ms = 2/3;
    // Motor Power : 0 ~ 10000   
    float PWM_DATA[6];
    for(int i=0; i<6; i++){
        PWM_DATA[i] = PWM_MIN + (PWM_MAX - PWM_MIN) * (Value[i]/10000.0);
        if(PWM_DATA[i] > PWM_MAX)PWM_DATA[i] = PWM_MAX;
    }
    pwm1.write(PWM_DATA[0]);
    pwm2.write(PWM_DATA[1]);
    pwm3.write(PWM_DATA[2]);
    pwm4.write(PWM_DATA[3]);
    pwm5.write(PWM_DATA[4]);
    pwm6.write(PWM_DATA[5]);
}

