
#ifndef MBED_ROBOFRIEN_GUI_H
#define MBED_ROBOFRIEN_GUI_H

#include "mbed.h"



class ROBOFRIEN_GUI {
public:
    void pc_rx_update();
    bool rx_bool();
    void Init();
    void Refresh();
    void SET_DATA();
/////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////// [H/M] HomePoint and Marker //////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////
    signed long Homepoint_Lat, Homepoint_Lng, Homepoint_Alt;
    signed long Marker_Mode[20],Marker_Lat[20], Marker_Lng[20], Marker_Alt[20], Marker_Speed[20];
    signed long Controller_Joystick[4], Gimbal_Joystick[3];
/////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////// [M/S] Mode and State ///////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////
    int8_t Mode1, Alarm,MissionState,CurrentMarker;
    uint8_t Bat1;
    bool button[5];
/////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////// [GPS] GPS //////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////
    unsigned long utc_time;
    signed long latitude,longitude,altitude;
    uint8_t SatNum;

/////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////// AHRS //////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////
    int32_t rollx100, pitchx100, yawx100;
    int32_t roll_ratex100, pitch_ratex100, yaw_ratex100;
    int32_t VXx100,VYx100,VZx100;

/////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////// [C/P] CAP/PWM ////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////
    int16_t cap[8];
    uint8_t pwm[8];
        
/////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////// [E/D] Extra & Debug /////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////    
    int32_t DEBUGx100[8];



/////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////// Configuration ///////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////    
    uint8_t headlight_period, headlight_dutyrate, sidelight_period, sidelight_dutyrate;
    int16_t raw_cap[8];
    int16_t cap_min[8], cap_neu[8], cap_max[8];
    int motor_min[6];
    uint8_t Compass_Calibration_Mode;
    bool attitude_configuration_bool;
    float declination_angle;
    int16_t limit_rollx100, limit_pitchx100;
    int32_t limit_roll_ratex100, limit_pitch_ratex100, limit_yaw_ratex100;
    int gain_px100[20], gain_dx100[20], gain_ix100[20];
    float mag_x_avg,mag_y_avg,mag_z_avg;
//    float calibrate_gap_roll,calibrate_gap_pitch;
    float cal_accel_bias[3];
    uint8_t DPN_Info;
    int pwm_info[6];
    void attitude_calibrate(float , float , float);
    void write_compass_setting_to_eeprom();
    void trans_flight_data(int id_dest, int data_parse_num);
    void trans_configuration_data(int id_dest, int data_parse_num, int data_parse_detail_num);
    void Trans();
    void TRANS_BUFFER();
    long MarkerChksum;
private:
    bool eeprom_refresh_bool;
    void trans_empty_data(int id_dest, int data_parse_num);
    bool TRANS_BUFFER_BUSY;
    uint8_t TRANS_BUF[100],TRANS_BUF_LEN,TRANS_BUF_CNT;
    int HomePointChksum;
};

#endif