#include "ROBOFRIEN_PID.h"


#define OUTPUT_LIMIT      3000
#define RAT_INTEGER_LIMIT   500
void ROBOFRIEN_PID::Init(){
    RAT_INTEGER[0] = 0;
    RAT_INTEGER[1] = 0;
    RAT_INTEGER[2] = 0;
}

void ROBOFRIEN_PID::update(){
    output_Data[0] = err_Rate[0] * RAT_KP[0];       // P GAIN    
    RAT_INTEGER[0] += err_Rate[0]/100.0 * RAT_KI[0];
    output_Data[0] += RAT_INTEGER[0];
    if(output_Data[0] > OUTPUT_LIMIT) output_Data[0] = OUTPUT_LIMIT;
    else if(output_Data[0] < -OUTPUT_LIMIT) output_Data[0] = -OUTPUT_LIMIT;

    output_Data[1] = err_Rate[1] * RAT_KP[1];       // P GAIN    
    RAT_INTEGER[1] += err_Rate[1]/100.0 * RAT_KI[1];
    output_Data[1] += RAT_INTEGER[1];
    if(output_Data[1] > OUTPUT_LIMIT) output_Data[1] = OUTPUT_LIMIT;
    else if(output_Data[1] < -OUTPUT_LIMIT) output_Data[1] = -OUTPUT_LIMIT;

    output_Data[2] = err_Rate[2] * RAT_KP[2];       // P GAIN    
    RAT_INTEGER[2] += err_Rate[2]/100.0 * RAT_KI[2];
    output_Data[2] += RAT_INTEGER[2];
    if(output_Data[2] > OUTPUT_LIMIT) output_Data[2] = OUTPUT_LIMIT;
    else if(output_Data[2] < -OUTPUT_LIMIT) output_Data[2] = -OUTPUT_LIMIT;
}

void ROBOFRIEN_PID::RAT_INTEGER_RESET(){
    RAT_INTEGER[0] = 0;
    RAT_INTEGER[1] = 0;
    RAT_INTEGER[2] = 0;
}

