#define eeprom_length 255


LocalFileSystem local("local");               // Create the local filesystem under the name "local"

volatile int eeprom_address[eeprom_length],eeprom_data[eeprom_length];
void eeprom_init(){
    int eeprom_chksum;
    FILE *file = fopen("/local/eeprom.txt", "r");  // Open "out.txt" on the local file system for writing    
    if(file == NULL){
        FILE *file = fopen("/local/eeprom.txt", "w");   // Write "out.txt ~~//
        for(int i=0; i<eeprom_length; i++){
            fprintf(file, "%d\t%d\r\n", i, 0);   
            wait(0.0001);
        }        
    }else{
        for(int i=0; i<eeprom_length; i++) {eeprom_address[i] = 0; eeprom_data[i] = 0; }
        for(int i=0; i<eeprom_length; i++){
            fscanf(file,"%d\t%d\r\n",&eeprom_address[i], &eeprom_data[i]);
            wait(0.0001);
        }
        int tmp;
        fscanf(file,"%d\t%d\t\n",&tmp, &eeprom_chksum);
    }
    fclose(file);
    int cal_eeprom_chksum = 0;
    for(int i=0; i<eeprom_length; i++){
        cal_eeprom_chksum += eeprom_data[i];
    }
    if( cal_eeprom_chksum != eeprom_chksum){
        while(1){
            DigitalOut myled1(LED1);
            DigitalOut myled2(LED2);
            DigitalOut myled3(LED3);
            DigitalOut myled4(LED4);
            myled1 = 1; myled2 = 1; myled3 = 1; myled4 = 1;
            wait(1);
            myled1 = 0; myled2 = 0; myled3 = 0; myled4 = 0;
            wait(1);
        }
    }
}

bool eeprom_refresh(){
    /// Write Data to EEPROM //
    bool OUTPUT_VALUE = false;
    int eeprom_chksum = 0;
    __disable_irq();
    FILE *file = fopen("/local/eeprom.txt", "w");  // Open "out.txt" on the local file system for writing    
//    if(file != NULL){
        OUTPUT_VALUE = true;
        for(int i=0; i<eeprom_length; i++){
            fprintf(file,"%d\t%d\r\n",i, eeprom_data[i]);
            wait(0.0001);
            eeprom_chksum += eeprom_data[i];
        }
        fprintf(file,"%d\t%d",eeprom_length,eeprom_chksum);    
//    }
    fclose(file);
    __enable_irq();
    return OUTPUT_VALUE;
}

void eeprom_write(int addr, int data){
    /// Change Data //
    eeprom_data[addr] = data;
}


int eeprom_read(int addr){
    return eeprom_data[addr];    
    
}

