#ifndef MBED_ROBOFRIEN_SBUS_H
#define MBED_ROBOFRIEN_SBUS_H

#include "mbed.h"


#define SIGNAL_OFF              0
#define MOTOR_OFF               1
#define MANUAL_ATTITUDE         2
#define MANUAL_VELOCITY         3
#define MANUAL_POSITION         4
#define AUTO_FLIGHT             5
#define HOME_POINT              6

class ROBOFRIEN_SBUS {
public:
    void Init();
    void update();
    bool end_bool,start_bool;  
    bool read_check;  
    int16_t channel[16];            // Range : -1000 ~ 1000
    int check_cnt;
    uint8_t CONTROLLER_STATE;
    /* **** CONTROL STATE **** */
    // 0 = SIGNAL OFF
    // 1 = MOTOR OFF
    // 2 = MANUAL - ATTITUDE
    // 3 = MANUAL - VELOCITY
    // 4 = MANUAL - POSITION
    // 5 = AUTO FLIGHT
    bool HOMEPOINT_BOOL;
private:
    uint8_t SBUS_CNT;
    uint8_t SBUS_ID[3];
    uint8_t SBUS_BUFF[25];
};

#endif