
#include "mbed.h"
#include "magnetometer.h"

void loop_forever(std::string const & str);

void mag_service()
{
    std::cout << "magnetometer service\n";

    if ( !mag_init()){
        loop_forever("failed to init magnetometer\n");
    }
    
    uint64_t constexpr update_rate_ms = 20U;

    auto wake = Kernel::get_ms_count();

    for (;;){
        
        mag_start_measurement();
        
        do{
           ThisThread::sleep_for(10U);
        }  while ( ! mag_data_ready() ); 
        
        quan::three_d::vect<quan::magnetic_flux_density::uT> v;
        if (mag_read(v)){
            std::cout << "val = " << v << '\n';
        }
      
        wake += update_rate_ms;
        ThisThread::sleep_until(wake);
    }
}

void led_blink_service()
{
    DigitalOut led(LED2,1);
    
    std::cout << "Blink service\n";
    
    uint64_t constexpr update_rate_ms = 500U;
    auto wake = Kernel::get_ms_count();
    for (;;){
        wake += update_rate_ms;
        ThisThread::sleep_until(wake);
        led = ( led == 0) ? 1: 0;
    }
}

int main()
{
    Thread magThread;
    magThread.start(mag_service);
    
    Thread blinkThread;
    blinkThread.start(led_blink_service);
    
    for (;;){;}
    
}