
#include "magnetometer.h"
#include "quan_time.h"
#include "hmc5883.h"
#include "resourceManager.h"

namespace {
    hmc5883L hmc5883L_ID1{resource::i2c1,0x3D};
}

bool mag_init()
{
    // if startup, allow magnetometer hardware time to start
    if ( Kernel::get_ms_count() < 500U){
        ThisThread::sleep_until(500U);
    }
    if (! hmc5883L_ID1.detected(true)){
        return false; // usr has been notified
    }
   
    hmc5883L_ID1.set_idle_mode();
   
    // gains from calib engine
    quan::three_d::vect<double> gain{1.37689,1.35057,1.56647};
    
    // offsets from calibration engine
    // Need an option to output raw data for calibration
    quan::three_d::vect<
        quan::magnetic_flux_density::uT
    > offset{10.5724_uT,-10.869_uT,2.241468_uT};
   
   // TODO should be max earthmagnetic field or 
   // as a function of location
   constexpr auto earth_magnetic_field_flux_density = 31.869_uT;
   
   return
        hmc5883L_ID1.set_samples_average(8) &&
        hmc5883L_ID1.set_range( earth_magnetic_field_flux_density * 2U) &&
        hmc5883L_ID1.set_gain(gain) && 
        hmc5883L_ID1.set_offset(offset);
}

bool mag_start_measurement()
{
    return hmc5883L_ID1.start_measurement();  
}

bool mag_data_ready()
{
    return hmc5883L_ID1.data_ready();
}

bool mag_read(quan::three_d::vect<quan::magnetic_flux_density::uT> & v)
{
    return hmc5883L_ID1.read(v);
}
