
#ifndef SKYSCRAPER_MBED_HMC5883L_H_INCLUDED
#define SKYSCRAPER_MBED_HMC5883L_H_INCLUDED

#include "magnetometer.h"
#include "I2CBusDevice.h"

struct hmc5883L : I2CBusDevice{
    
    hmc5883L(I2C& i2cIn,uint8_t addressIn);

    bool detected(bool verbose)const;
    
    bool data_ready()const;
    
    // assume mag_data_ready has returned true before call
    bool read(quan::three_d::vect<quan::magnetic_flux_density::uT> & v)const;
    
    bool start_measurement()const;
    
private:

    friend bool mag_init();
    
    bool make_measurement(
        quan::three_d::vect<
            quan::magnetic_flux_density::uT
        >& result
    )const;
  //  bool write_reg(uint8_t idx, uint8_t val)const;
    bool set_reg_idx(uint8_t idx_in)const;
    
    // 00 Configuration Register A       R/W
    static constexpr char cfg_regA = 0;
    
    //01 Configuration Register B       R/W
    static constexpr char cfg_regB = 1;
    
    //02 Mode Register                  R/W
    static constexpr char mode_reg = 2;
    
    //03 Data Output X MSB Register     R
    static constexpr char dout_reg = 3;
    //04 Data Output X LSB Register     R
    //05 Data Output Z MSB Register     R
    //06 Data Output Z LSB Register     R
    //07 Data Output Y MSB Register     R
    //08 Data Output Y LSB Register     R
    
    //    09 Status Register                R
    static constexpr char status_reg = 9;
    
    // 10 Identification Register A      R
    static constexpr char id_regA = 10;
    // 11 Identification Register B      R
    // 12 Identification Register C      R
    
    bool write_reg(uint8_t idx, uint8_t val)const;
    bool get_reg(uint8_t idx_in, uint8_t& result)const;
    bool modify_reg(uint8_t idx, uint8_t and_val, uint8_t or_val)const;
    bool data_locked()const;
    bool set_continuous_measurement_mode()const;
    bool set_gain( quan::three_d::vect<double> const & gain);
    bool set_offset(quan::three_d::vect<
            quan::magnetic_flux_density::uT
            > const & offset);
    
    bool set_idle_mode()const;
    
    // 1,2,4,8 available
    bool set_samples_average(int n_samples)const;
    
    // may change so that always one-shot
    // ignore continousos mode
    //data rate 0.75, 1.5, 3 ,7.5, 15 (Default) , 30, 75
    template <int N, int D=1>
    bool set_data_rate()const;
    
    bool set_positive_bias()const;
    bool set_negative_bias()const;
    bool mag_clear_bias()const;
    bool set_range(quan::magnetic_flux_density::uT const & range_in);
   
    quan::magnetic_flux_density::uT 
    get_flux_density_range()const;
    //------------
       // per lsb defualt resolution
    quan::magnetic_flux_density::uT mag_resolution;
    // range before saturation
    quan::magnetic_flux_density::uT mag_range;
    quan::three_d::vect<double> mag_gain;
    quan::three_d::vect<quan::magnetic_flux_density::uT> mag_offset;
};





#endif