
#ifndef SKYSCRAPER_MBED_I2C_BUS_DEVICE_HPP_INCLUDED
#define  SKYSCRAPER_MBED_I2C_BUS_DEVICE_HPP_INCLUDED

#include "mbed.h"

struct I2CBusDevice{
    
    constexpr I2CBusDevice(I2C& i2cIn,uint8_t addressIn)
    : m_i2c{i2cIn},m_address{addressIn}{}
    
    int i2c_write(const char *data, int length,bool repeated = false)const
    {
        return m_i2c.write(m_address,data,length, repeated);
    }
    
    int i2c_read(char *data, int length, bool repeated=false)const
    {
       return m_i2c.read(m_address,data,length,repeated); 
    }
    
    private:
    I2C & m_i2c;
    int const m_address;
};

#endif