
#include "mbed.h"
#include <cstring>
#include <I2C.h>
#include <Serial.h>

namespace {
    DigitalOut led1(LED1);
    
    Serial pc(USBTX, USBRX); // tx, rx
    
    I2C i2c(PA_10,PA_9); // I2C1
    
    const uint8_t i2c_addr = 0x3D;
    // idreg
    const char id_regA = 10U;
    const char id_regB = 11U;
    const char id_regC = 12U;
}

int main()
{
    //wait for mag to init
    Thread::wait(500);
    
    // move pointer to loc
    if ( i2c.write(i2c_addr,&id_regA,1) == 0){
        char id_input[4];
        i2c.read(i2c_addr,id_input,3);
        id_input[3] = '\0';
        if (strcmp(id_input,"H43") == 0){
          pc.printf("Detected a HMC5883",id_input);
        }else{
         pc.printf("config Not got a HMC5883",id_input);
        }
    }else{
        pc.printf("HMC5883 write failed\n");
    }
    //check we are still running
    for (;;){
       led1 = !led1;
       Thread::wait(250);
    }
}