#include "mbed.h"
#include "math.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"


SDBlockDevice sd(p5, p6, p7, p8);
FATFileSystem   fs("sd");

#include "tar.h"




#include "ST7735.h"

ST7735 TFT(p5, p6, p7, p9, p10, p11);
//ST7735 TFT(p11, p12, p13, p15, p16, p17);
PwmOut TFT_BackLight(p25);

DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled4(LED4);

float p = 3.1415926;

Timer t;

extern int confSaber[]; 
extern int theme[]; 
extern int confSaber_mini[]; 
extern int theme_mini[]; 

FILE * fp;

int main()
{
    sd.init();
    fs.mount(&sd);
    
    myled2 = 1;
    
    TFT_BackLight = 0;

    TFT.initR(INITR_MINI160x80_RS); // INITR_MINI160x80
    
    TFT.setRotation(2);
    TFT.fillScreen(ST7735_BLACK);
    TFT_BackLight = 1;
    
    //fp = fopenTar("/sd/mydir/config.thm", "config.bmp");
    //TFT.DrawBMP(0, 0, fp);
    //fclose(fp);
    
    
    int i = 1;
    while(0) {
        fp = fopen("/sd/mydir/cat.ani", "r");
        TFT.DrawANI(0, 30, fp, i);
        fclose(fp);
        wait_ms(20);
        i++;
        if(i == 9) i = 1;
    }
    

    /*
    fp = fopen("/sd/mydir/test1_16.gif", "r");
    TFT.DrawGIF(0, 0, fp);        
    fclose(fp);
    
    fp = fopen("/sd/mydir/test1_ff.gif", "r");
    TFT.DrawGIF(40, 0, fp);        
    fclose(fp);
    
    fp = fopen("/sd/mydir/test2_4.gif", "r");
    TFT.DrawGIF(0, 80, fp);
    fclose(fp);
    
    fp = fopen("/sd/mydir/test2_16.gif", "r");
    TFT.DrawGIF(40, 80, fp);      
    fclose(fp);
    
    fp = fopenTar("/sd/mydir/config.thm", "test1_16.gif");
    TFT.DrawGIF(20, 0, fp);
    fclose(fp);*/
    
    
    TFT.fillCircle(10, 10, 5, ST7735_RED);
    TFT.fillCircle(150, 10, 5, ST7735_GREEN);
    TFT.fillCircle(150, 70, 5, ST7735_BLUE);
    TFT.fillCircle(10, 70, 5, ST7735_WHITE);
    
    
    for ( int i=0; i<360; i+=10 ) {
        TFT_BackLight = cos( i*2.0*3.14/360 ) * 0.5 + 0.5;
        wait(0.1);
    }
    
    TFT.setCursor(0, 0);
    TFT.setTextColor(ST7735_WHITE);
    TFT.setTextWrap(true);
    TFT.write("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur adipiscing ante sed nibh tincidunt feugiat. Maecenas enim massa, fringilla sed malesuada et, malesuada sit amet turpis. Sed porttitor neque ut ante pretium vitae malesuada nunc bibendum. Nullam aliquet ultrices massa eu hendrerit. Ut sed nisi lorem. In vestibulum purus a tortor imperdiet posuere. ", 0xffff);
    
    //wait(1);
    
    //tftPrintTest();
    
    /*
    t.start();
    fp = fopenTar("/sd/mydir/config.thm", "config.bmp");
    TFT.DrawBMP(0, 0, fp);
    t.stop();
    fclose(fp);
    printf("config TAR : %f seconds sur SD\n", t.read());
    t.reset();
    
    
    t.start();
    fp = fopenTar("/sd/mydir/config.thm", "main.bmp");
    TFT.DrawBMP(0, 80, fp);
    t.stop();
    fclose(fp);   
    printf("config TAR : %f seconds sur SD\n", t.read());
    t.reset();
    */
    
    /*
    wait(1);
    t.start();
    fp = fopen("/sd/mydir/tour.bmp", "r");
    TFT_BackLight = 0;
    TFT.DrawBMP(0, 0, fp);
    TFT_BackLight = 1;
    t.stop();
    fclose(fp);
    printf("Tour : %f seconds sur SD\n", t.read());
    t.reset();
    
    t.start();
    fp = fopen("/sd/mydir/test2.bmp", "r");
    TFT.DrawBMP(0, 0, fp);
    t.stop();
    fclose(fp);
    printf("coeur : %f seconds sur SD\n", t.read());
    t.reset();
    */
   
    
    //wait(1);
    //TFT.fillScreen(ST7735_BLACK);
    //TFT.DrawStarfield(80, 40, 1, 0, 300, 4);
    //TFT.fillScreen(ST7735_BLACK);
    
    wait(1);
    TFT.DrawRam(11, 52, 57, 57, confSaber);
    TFT.drawFastHLine(0, 0, 80, ST7735_GREEN);
    wait(1);
    TFT.scrollBmp(0, 0, BOTTOM_TO_TOP, theme);
    wait(1);
    TFT.scrollBmp(0, 0, TOP_TO_BOTTOM, confSaber);
    
    
    /*
    wait(1);
    TFT.drawFastHLine(0, 14, 80, 0x2104);
    TFT.DrawRam(1, 1, 11, 11, confSaber_mini);
    wait(1);
    TFT.scrollBmp(15, 0, BOTTOM_TO_TOP, theme);
    wait(1);
    TFT.scrollBmp(15, 0, TOP_TO_BOTTOM, confSaber);
    TFT.drawFastHLine(0, 146, 80, 0x2104);
    TFT.DrawRam(1, 148, 11, 11, theme_mini);
    wait(1);
    TFT.scrollBmp(15, 15, BOTTOM_TO_TOP, theme);
    wait(1);
    TFT.scrollBmp(15, 15, TOP_TO_BOTTOM, confSaber);  
    */
    
    while(1) {
        myled = 1;   
        wait(1);
        myled = 0;
        wait(1);
    }
}
