#include "mbed.h"
#include "tar.h"

FILE* fopenTar(char *tarfile, char *namefile) { 
    
    int i;
    char buf[32];
    char sizeStr[12];
    char *valExit = "error";
    int size, offset = 0;
    
    FILE *Tar = fopen(tarfile, "r");
    
    while(!feof(Tar)) {
        for(i=0; i <= strlen(namefile); i++) buf[i] = fgetc(Tar);
        
        if(!strcmp(buf, namefile)) {
            valExit = "";
            break;
        }
        
        fseek(Tar , 124+offset , SEEK_SET);
        for(i=0; i < 12; i++) sizeStr[i] = fgetc(Tar);
        //printf("size string: %s; octal: %d; dec.: %x\n", sizeStr, atoi(sizeStr), oct2dec(atoi(sizeStr)) );
        
        size = oct2dec(atoi(sizeStr));
        if(offset % 512 != 0) offset += (size/512 + 2)*512;
        else offset += (size/512 + 1)*512;
        
        fseek(Tar , offset , SEEK_SET);  
    }
    
    if(valExit == "error") {
        printf("file \"%s\" not find in tar\n", namefile); 
        return NULL;
    } else {
        fseek(Tar, offset+512 , SEEK_SET);
        return Tar;
    }
}

int oct2dec(int n) /* Function to convert octal to decimal */
{
    int decimal=0, i=0, rem;
    while (n!=0)
    {
        rem = n%10;
        n/=10;
        decimal += rem*pow(8.0,i);
        ++i;
    }
    return decimal;
}