#include "mbed.h"
#include <IQS5xx.h>

/***** Object Declarations *****/
IQS5xx trackPad(p28, p27, p17);

DigitalOut led1(LED1);

//DigitalIn rdy(p17);
InterruptIn rdyInter(p17);

void ISR1() { //this is the response to interrupt, i.e. the ISR

    uint8_t ui8TempData[30], i;
        
        trackPad.I2C_Read(GestureEvents0_adr, &trackPad.Data_Buff[0], 44);
        
        if((trackPad.Data_Buff[3] & SNAP_TOGGLE) != 0) {
            
            // If there was a change in a snap status, then read the snap status 
            // bytes additionally. Keep previous valus to identify a state change
            //
            trackPad.I2C_Read(SnapStatus_adr, &ui8TempData[0], 30);
            for(i = 0; i < 15; i++) {
                trackPad.ui16PrevSnap[i] = trackPad.ui16SnapStatus[i];
                trackPad.ui16SnapStatus[i] = ((uint16_t)(ui8TempData[2*i])<<8) + (uint16_t)ui8TempData[(2*i)+1];
            }
        }
        
        //
        // Terminate the communication session, so that the IQS5xx can continue 
        // with sensing and processing
        //
        trackPad.Close_Comms();
        //
        // Process received data 
        //
        trackPad.Process_XY();
}

int main() {
    
    //rdy.mode(PullUp);
    
    rdyInter.rise(&ISR1);
    
    trackPad.AcknowledgeReset();
    
    trackPad.checkVersion();
    
    while(1) {
        
        

        led1 = 1;
        wait(0.5);
        led1 = 0;
        wait(0.5);  
    }  
}

