/* IQS5xx.h
 * Tested with mbed board: LPC1768
 * Author: Kevin Sac
 * skydarc@gmail.com
 */

#include "mbed.h"

#include "IQS5xx_addresses.h"




/**
* This class allows for easy control over a IQS5xx IC.
*/
class IQS5xx {
    public:
    
        uint8_t  Data_Buff[44];
        uint16_t ui16SnapStatus[15], ui16PrevSnap[15];
    
        /**
         * @param sda the pin identifier for SDA I2C signal
         * @param scl the pin identifier for SCL I2C signal
         * @param i2c_addr the 8-bit I2C address for this device. Note that LSB is a don't care.
         */
        IQS5xx(PinName sda, PinName scl, PinName rdy);
        
        uint8_t I2C_Write(uint16_t ui16RegisterAddress, uint8_t *pData, uint8_t ui8NoOfBytes);
        uint8_t I2C_Read(uint16_t ui16RegisterAddress, uint8_t *pData, uint8_t ui8NoOfBytes);
        
        // Public Methods
        void AcknowledgeReset(void);
        void checkVersion(void);
        void DisplaySnap(void);
        void Process_XY(void);
        void Close_Comms();
  
    private:
        // Private Variables
        I2C &i2c_;
        char i2cRaw[sizeof(I2C)];
        DigitalIn _readyPin;
        uint8_t ui8Success;
        
        
        // Private Methods
        

        uint8_t I2C_Write2(uint16_t ui16RegisterAddress, uint8_t *pData, uint8_t ui8NoOfBytes);
        uint8_t I2C_Read2(uint16_t ui16RegisterAddress, uint8_t *pData, uint8_t ui8NoOfBytes);
        
        void Print_signed(int16_t i16Num);
        void Print_unsigned(uint16_t ui16Num);
        
};

 