// roomba-song
// by Mark Williams
// 4/2/2012
//
// Simple code for iRobot Roomba 560
// makes the robot dance around and play "for whom the bell tolls"

#include "mbed.h"

InterruptIn button(p11);
Serial device(p9, p10);  // tx, rx


void roombastop() {
    // Stop
    device.putc(137);   // Drive
    device.putc(0x00);
    device.putc(0x00);
    device.putc(0x00);
    device.putc(0x00);
}

void roombacw() {
    // Turn in place clockwise
    device.putc(137);   // Drive
    device.putc(0x00);  // Velocity: 0x00c8 = 200
    device.putc(0xc8);
    device.putc(0xff);  // Radius: 0x0001 = Turn in place clockwise
    device.putc(0xff);

}

void roombaccw() {
    // Turn in place counter-clockwise
    device.putc(137);   // Drive
    device.putc(0x00);  // Velocity: 0x00c8 = 200
    device.putc(0xc8);
    device.putc(0x00);  // Radius: 0x0001 = Turn in place counter-clockwise
    device.putc(0x01);
}


void roombaforward() {
    // Forward
    device.putc(137);   // Drive
    device.putc(0x00);  // Velocity: 0x00c8 = 200
    device.putc(0xc8);
    device.putc(0x80);  // Radius: 0x8000 = Straight
    device.putc(0x00);
}

void roombabackward() {
    // Backward
    device.putc(137);   // Drive
    device.putc(0xff);  // Velocity: 0xff38 = -200
    device.putc(0x38);
    device.putc(0x80);  // Radius: 0x8000 = Straight
    device.putc(0x00);
}


void dance() {

}

int main() {
    device.baud(115200);    // the default baud rate of Roomba 530
    //device.baud(19200);

    // Start
    device.putc(128);   // Start -&gt; Passive Mode
    wait(.05);
    device.putc(130);   // Safe Mode
    wait(.05);
    
    wait(1);

    // for whom the bell tolls bass riff
    // D  C#  C  B  DB  G  F#  D  D  C#
    // load a song
    device.putc(140);   // Song
    device.putc(1);   // Song number
    device.putc(11);  // Song length (0x0A = 11)
    
    device.putc(50);  // Note 
    device.putc(16);  // Note length
    
    device.putc(49);  // Note 
    device.putc(16);  // Note length
    
    device.putc(48);  // Note 
    device.putc(16);  // Note length
    
    device.putc(47);  // Note 
    device.putc(32);  // Note length
    
    device.putc(50);  // Note 
    device.putc(8);  // Note length
    
    device.putc(47);  // Note 
    device.putc(8);  // Note length
    
    device.putc(43);  // Note 
    device.putc(16);  // Note length
    
    device.putc(42);  // Note 
    device.putc(16);  // Note length
    
    device.putc(50);  // Note 
    device.putc(16);  // Note length
    
    device.putc(38);  // Note 
    device.putc(16);  // Note length
    
    device.putc(37);  // Note 
    device.putc(32);  // Note length
    
    
    // load a song
    device.putc(140);   // Song
    device.putc(2);   // Song number
    device.putc(11);  // Song length (0x0A = 11)
    
    device.putc(62);  // Note 
    device.putc(16);  // Note length
    
    device.putc(61);  // Note 
    device.putc(16);  // Note length
    
    device.putc(60);  // Note 
    device.putc(16);  // Note length
    
    device.putc(59);  // Note 
    device.putc(32);  // Note length
    
    device.putc(62);  // Note 
    device.putc(8);  // Note length
    
    device.putc(59);  // Note 
    device.putc(8);  // Note length
    
    device.putc(55);  // Note 
    device.putc(16);  // Note length
    
    device.putc(54);  // Note 
    device.putc(16);  // Note length
    
    device.putc(62);  // Note 
    device.putc(16);  // Note length
    
    device.putc(50);  // Note 
    device.putc(16);  // Note length
    
    device.putc(49);  // Note 
    device.putc(32);  // Note length
    
    roombacw();
    wait(.5);
    roombaccw();
    wait(.5);
   // roombastop();
    //roombaforward();
   // wait(0.5);
    //roombastop();
    roombastop();
    
    // play a song
    device.putc(141);  // Play
    device.putc(2);    // song #2
    
    wait(3);
    roombacw();
    wait(.5);
    roombaccw();
    wait(.5);
    roombastop();
    
    
    // play a song
    device.putc(141);  // Play
    device.putc(2);    // song #2
    
    wait(3);
    roombacw();
    wait(.5);
    roombaccw();
    wait(.5);
    roombastop();
    
    // play a song
    device.putc(141);  // Play
    device.putc(2);    // song #2
    
    roombaccw();
    wait(3);
    roombacw();
    wait(.5);
    
    // play a song
    device.putc(141);  // Play
    device.putc(2);    // song #2
    
    roombaccw();
    wait(0);
    roombastop();  
    
    
    wait(6);

    // Passive Mode
    device.putc(128);   // Start -&gt; Passive Mode
}