#include "mbed.h"
#include "MPL115A2.h"
#include "BME280_SPI.h"
#include "TextLCD.h"


I2C i2c(p9, p10);        // sda, scl

Serial pc(USBTX, USBRX); // tx, rx

MPL115A2 mpl_sensor(&i2c);

BME280_SPI bme_sensor(p5, p6, p7, p8); // mosi, miso, sclk, cs

TextLCD lcd(p24, p25, p26, p27, p28, p29); // rs, rw, e, d4, d5, d6, d7

InterruptIn button(p11);
bool display_hPa = true;
const double hPa2cmH2O = 1.01974428892;

void toggleDisplayFormat() {
    display_hPa ^= display_hPa;
}

int main() {
    
    button.rise(&toggleDisplayFormat);
    
    mpl_sensor.begin();       
    
    // main loop
    while(1) 
    {        
        mpl_sensor.ReadSensor();
        lcd.cls(); // WITHOUT THIS THE ENDLESS BEEP OCCURS
        if(display_hPa) {
            lcd.printf("MPL: %4.4f hPa\nBME: %4.4f hPa%\n", 
                        mpl_sensor.GetPressure(),
                        bme_sensor.getPressure());
            pc.printf("MPL: %4.4f hPa\nBME: %4.4f hPa%\n", 
                        mpl_sensor.GetPressure(),
                        bme_sensor.getPressure());
        }
        else {
            lcd.printf("MPL: %4.4f cmH2O\nBME: %4.2f cmH2O%\n",
                        (mpl_sensor.GetPressure() * hPa2cmH2O),
                        (bme_sensor.getPressure() * hPa2cmH2O));
            pc.printf("MPL: %4.4f cmH2O\nBME: %4.2f cmH2O%\n",
                        (mpl_sensor.GetPressure() * hPa2cmH2O),
                        (bme_sensor.getPressure() * hPa2cmH2O));
        }     
        wait(.1); 
    }
}
