#include "mbed.h"
#include "BME280.h"
#include "TextLCD.h"

Serial pc(USBTX, USBRX);

#if defined(TARGET_LPC1768)
BME280 sensor(p28, p27);
#else
BME280 sensor(I2C_SDA, I2C_SCL);
#endif

TextLCD lcd(p10, p12, p15, p16, p29, p30); // rs, rw, e, d4, d5, d6, d7

int main() {
    sensor.initialize();
    while(1) {
        lcd.cls();
        lcd.printf("%2.2f degC, %04.2f hPa, %2.2f %%\n", sensor.getTemperature(), sensor.getPressure(), sensor.getHumidity());
        wait(1);
    }
}
