#include "mbed.h"

#ifndef STEERING_H
#define STEERING_H

#define PIN_PWM_STEERING p26 //or whatever
#define PIN_DIR_STEERING p15 //or whatever

#define MAX_PWM_SIGNAL 0.9f

#define MAX_STEER_ANGLE 80
#define MIN_STEER_ANGLE -80

class Steering
{
    public:
    
    Steering();
    ~Steering();
    
    void turn(float percentage);
    void setSteerAngle(int angle);
    void addToSteerAngle(int angle);
    int getSteerAngle();
    int readCurrentAngle();
    int getCurrentAngle();
    
    private:
    
    int _steerAngle;
    int _currentAngle;
    
    PwmOut _pwm;
    DigitalOut _dir;
    
};

#endif