#include "Steering.h"

Steering::Steering() : _pwm(PIN_PWM_STEERING), _dir(PIN_DIR_STEERING)
{
    _pwm.period_ms(20); //needs to be changed!!!
    _currentAngle = 0;
    _steerAngle = 0;
}

Steering::~Steering()
{
    
}

void Steering::setSteerAngle(int angle)
{
    if (angle > MAX_STEER_ANGLE) angle = MAX_STEER_ANGLE;
    if (angle < MIN_STEER_ANGLE) angle = MIN_STEER_ANGLE;
    _steerAngle = angle;
}

void Steering::addToSteerAngle(int angle)
{
    int sum = _steerAngle + angle;
    setSteerAngle(sum);
}

int Steering::getSteerAngle()
{
    return _steerAngle;
}

int Steering::readCurrentAngle()
{
    _currentAngle = 5; //replace by reading the sensor
    return _currentAngle;
}

int Steering::getCurrentAngle()
{
    return _currentAngle;
}

void Steering::turn(float percentage)
{    
    //write to motor -1 ,1 direction
    _pwm.write(abs(percentage)/100.0);
    if (percentage < 0) _dir.write(0);
    else _dir.write(1);
}