#include "mbed.h"

#ifndef MOTOR_CONTROLLER_H
#define MOTOR_CONTROLLER_H

#define BAUD_RATE 115200
#define PIN_TX p9
#define PIN_RX p10
#define ENTER 0x0D

Serial mc(PIN_TX, PIN_RX);  // tx, rx

void Rx_interruptMC();
char temp_rx[80];

int initMotorController()
{
    mc.baud(BAUD_RATE);
    
    // Setup a serial interrupt function to receive data
    mc.attach(&Rx_interruptMC, Serial::RxIrq);
    
    return 0;
}

void Rx_interruptMC()
{
    //led2 = 1;
    bool lineEnd = true;
    char raw_rx[80];
    int i = 0;
    
    while (lineEnd)
    {
        raw_rx[i] = mc.getc();
        if ((int)raw_rx[i] == ENTER)
        {
            lineEnd = false;   
        }
        i++;
        led3 = lineEnd;
    }
    
    //Here now the Values of the MC in the current Value
    sprintf(temp_rx,raw_rx);
    //led2 = 0;
}
void writeLine(char *line)
{
    mc.printf("%s\r\n",line);
}

void writeWord(char *word)
{
    mc.printf("%s",word);
}

void startStatusWriting()
{
    writeLine("status_start");
}

void endStatusWriting()
{
    writeLine("status_end");
}


#endif