
#ifndef CONTROLLER_H
#define CONTROLLER_H

#include "Pid_control.h"
#include "Motor.h"
#include "Brake.h"
#include "Steering.h"


#define max_throttle 50 // 50% maximum throttle
#define max_braking  50
#define braking_p1   1.0
#define braking_p2   2.0
#define braking_p3   4.0
#define speed_brake_1 5.0
#define speed_brake_2 10.0
#define speed_brake_3 50.0
#define min_speed     0.5 //at lower speeds vehicle will brake and stop


class Controller
{
    public:
    int  update(int Status);
    
      Controller();
    ~Controller();
   
    
    private:
    
    Pid_control pid_control_speed;
    Pid_control pid_control_steering;
    Motor motor;
    Brake brake;
    Steering steering;
      
    int _drive_direction;
    int _drive_direction_old;
    int _drive_direction_change;
    int _target_speed;
    int _actual_speed;
    int _target_steering_angle;
    int _actual_steering_angle;
    int _u_steering;
    int _u_throttle; 


    int Pid_controller(void);
    void actuate(int u); // value -100 to 100 full braking to full throttle
    void stop(void);
    
    };
    
    #endif