#include "mbed.h"
#include "Controller.h"

#ifndef BRAKE_H
#define BRAKE_H

#define PIN_BUTTON_BRAKE p22 //or whatever
#define PIN_PWM_BRAKE p21 //or whatever
#define PIN_DIR_BRAKE p23 //or whatever

#define CALIBRATION_FACTOR 200 // Steps per Rotation

#define MAX_SPEED_BRAKE     3 // 3 rotations per second
#define MAX_ROTATIONS_FOR_BRAKEING 10.0 //still needs to 
#define HYSTERESIS 5

class Brake
{
    public:
    
    Brake();
    ~Brake();
    
    void calibrateServo();
    bool getBrakeing();
    void brake(int percantage, int speed);
        
    private:
    
    int drive_homeposition(void);
    int drive_brake(int _percentage, int _speed);
    bool _brakeing;
    DigitalIn _brakeButton;
    PwmOut _pwm;
    DigitalOut _dir;
    float _percantage;
    bool brake_switch;
    int ref_time;
    int cur_time;
    int percentage_old;
    int enable_drive;
    int calculated_position;
    int direction;
    int diff_time;
    int state_brakeButton_old;
    
  
    Timer t1; 
    Timer t2; 
};

#endif