#include "Brake.h"

Brake::Brake() : _brakeButton(PIN_BUTTON_BRAKE), _pwm(PIN_PWM_BRAKE),
                 _dir(PIN_DIR_BRAKE)
{    
    _pwm.period_ms(20); //needs to be changed!!!
    Timer t1;  
    Timer t2;  
    t1.start();
    percentage_old=0;
     int state_brakeButton_old=0;
    enable_drive =0;
    direction=1; // 1 forward, -1 backward
}

Brake::~Brake()
{
    
}

void Brake::calibrateServo()
{
 
    
}


void Brake::brake(int percentage, int speed)
{
    

    if(percentage != percentage_old)
        {
            enable_drive =1;
            
            if(percentage_old < percentage)
            {
                direction = 1; // forward   
            }
            else
            {
                 direction = -1;  // backward
            }
            
        }
      
////////////

if( state_brakeButton_old != _dir)
{
  calculated_position=0; // recalibrate every time it switch state changes  
}

////////////////

    if( enable_drive == 1)
    {
        if( percentage == 0)
        {
            drive_homeposition();
        }
        else
        {
            
            drive_brake(direction, speed);
            diff_time = t1.read_ms() - ref_time;
                   
            
            calculated_position = calculated_position + (((((float)speed)/100.0f)*MAX_SPEED_BRAKE* (((float)diff_time)/1000.0)*direction))/(MAX_ROTATIONS_FOR_BRAKEING);
            
            //maximum speed 5 rpm
            
            if( abs(calculated_position - percentage) < HYSTERESIS)
            {
                enable_drive =0;
            }
        }

    }
    
  
if(diff_time > 600000) // After 10 Minutes Timer is Reset, avoid overflow
{
  t1.reset();  
}    

state_brakeButton_old = _dir;
ref_time = t1.read_ms();
}

int Brake::drive_homeposition()
{
    if( _brakeButton ) // check if 1 or 0 is engaged
    {
        drive_brake(-1, 100.0);
    }
    else
    {
         drive_brake(1, 0); // home position reached
    }
    
    
}
int Brake::drive_brake(int direction, int _speed)
{
    _pwm.write(( float(abs(_speed)))/100.0f);
   
   if(direction==1)
   {
    _dir = 1; // engage brakes
   }
   else
   {
      _dir = 0; // release brakes
   }
}

bool Brake::getBrakeing()
{
    return _brakeing;
}
