#include "mbed.h"
#include "ESP8266.h"
 
InterruptIn motion(D2);

Serial pc(USBTX,USBRX); //UART/Serial Communication

ESP8266 wifi(PTE0, PTE1, 115200); // Setting up Baud Rate for WIFI ESP Module
char snd[255],rcv[1000];

#define IP "184.106.153.149" // Defining Thingspeak IP Address
 

int dm = 0; //dm = Detected Motion
 
void motiondetection(void)
{
    dm = 1;
}
    
//Defining the necessary Functions to be used//

void wifi_send(void);

int cnt;


//Execution of Main program 

int main(void)
{
    cnt = 0; //Setting counter value to zero
    motion.rise(&motiondetection);
    
    pc.baud(9600); //Setting up Baud Rate for UART
    
// WIFI Initialization Part//
    
    pc.printf("SET mode to AP\r\n");
    wifi.SetMode(1);    // Setting ESP to mode 1
    wifi.RcvReply(rcv, 1000);    //In order to receive response from ESP
    pc.printf("%s",rcv);    //Display obtained response on TeraTerm
    pc.printf("Conneting to AP\r\n");
    
    //wifi.Join("BHNTG1682G0382", "a2c77382");    
    wifi.Join("hello", "hellohello"); // Add Username and Password of the Network to which WIFI ESP module is connected
    wifi.RcvReply(rcv, 1000);    //In order to receive response from ESP
    pc.printf("%s", rcv);    //Display obtained response on TeraTerm
    wait(8);  //Wait for 8 seconds
    
    pc.printf("Getting IP\r\n");    // Gets IP address
    wifi.GetIP(rcv);    //To receive IP
    pc.printf("%s", rcv);//Display obtained response on TeraTerm    
    wait(5); // Delay 5 sec to give the pir time to get snapshut of the surrounding
    pc.printf("Initializing WiFi\r\n");
    
    while(1) {
        if(dm) {
            cnt++;
            dm = 0;
            pc.printf("ALERT!! Intrusion Detected!! I've detected %d times since reset\n", cnt);
            pc.printf("Now uploading status to Cloud\n\r");
            wifi_send();
        }
    }
}
// Main program ends//


//Routing the inofrmation to Cloud//

void wifi_send(void)
{   
pc.printf("*************Uploading WIFI Data*************\r\n");

    pc.printf("\r\nTo set WIFI into Single Channel mode\r\n");

    strcpy(snd,"AT+CIPMUX=0");//To Set WIFI into Single Channel mode
    wifi.SendCMD(snd);
    pc.printf(snd);
    
    wifi.RcvReply(rcv, 1000);
    pc.printf("\r\nMode Status: %s", rcv);
    


//Connecting to THINGSPEAK server// 
    pc.printf("\r\nConnecting to THINGSPEAK server\r\n");
    strcpy(snd,"AT+CIPSTART=\"TCP\",\"api.thingspeak.com\",80");    
    pc.printf("\r\nSending: %s",snd);
    wifi.SendCMD(snd);
    wifi.RcvReply(rcv, 1000);
    pc.printf("\r\nSever Status: %s", rcv);
    
//Deliver Data/Characters//   
    pc.printf("\r\nDelivering Data..");
    strcpy(snd,"AT+CIPSEND=84");  
    wifi.SendCMD(snd);
    pc.printf("\r\nSending: %s",snd); 
    wifi.RcvReply(rcv, 1000);
    pc.printf("\r\nSent Status: %s", rcv);
    
//Upload values to Cloud based website i.e. ThingSpeak in order to obtain Graphical Display//

    pc.printf("Uploading values to Thingspeak\r\n");
    sprintf(snd,"GET https://api.thingspeak.com/update?key=2DNGOOKD3OZBMVV5&field1=%d HTTP/1.0\r\n\r\n",cnt);   //67,76,84
    //sprintf(snd,"GET https://api.thingspeak.com/update?key=2DNGOOKD3OZBMVV5&field1=%d HTTP/1.0\r\n\r\n",cnt);   //67,76,84
    pc.printf("\r\nSending: %s",snd);
    wifi.SendCMD(snd);
    wait(1);
    wifi.RcvReply(rcv, 1000);
    pc.printf("\r\nSent Status: %s", rcv);
    wait(1);

//Closing the connection with Server//
   
    pc.printf("\r\nClose the Connection\r\n");                                
    strcpy(snd,"AT+CIPCLOSE");        //Command used to close the connection with server
    wifi.SendCMD(snd);
    pc.printf("\r\nSending: %s",snd);
    wait(1);
    wifi.RcvReply(rcv, 1000);
    pc.printf("Close Connection Status: %s", rcv);   

    pc.printf("\r\nClose connection\r\n");                                
    strcpy(snd,"AT+CIPCLOSE");        
    wifi.SendCMD(snd);
    pc.printf("\r\nSending: %s",snd);
    wifi.RcvReply(rcv, 1000);
    pc.printf("Close Connection Status: %s", rcv);
    pc.printf("\r\nEnd of Closed Connection Status Response\r\n\r\n");
    
}
