#include"mbed.h"
#include"SerialMultiByte.h"
#include"pin_config.h"

SerialMultiByte sita_s(S_SERIALTX,S_SERIALRX);
SerialMultiByte ue_s(U_SERIALTX,U_SERIALRX);
DigitalIn start(USER_BUTTON);
Serial pc(USBTX,USBRX,115200);

DigitalOut debug_led_0(LED0);
DigitalOut debug_led_1(LED1);
DigitalOut debug_led_2(LED2);
DigitalIn debug_button(PC_4);

int mode=0;
int u_mode=0,s_mode=0,m_mode=0;
unsigned char itidata[4];
int X_,Y_;
int data_a;

void to_sita(){
  unsigned char data[5];
  unsigned char getdata[1];
  data[0] = mode;
   for(int i=0;i<4;i++){
     data[i+1] = itidata[i];
  }
  sita_s.sendData(data,5);
  sita_s.getData(getdata);
  s_mode = getdata[0];
}

void to_ue(){
  unsigned char data[1];
  unsigned char getdata[5];
  data[0] = mode;
  ue_s.sendData(data,1);
  ue_s.getData(getdata);
  u_mode=getdata[0];
  for(int i=0;i<4;i++){
     itidata[i] = getdata[i+1];
  }
}


int main()
{
    sita_s.setHeaders('A','Z');
    sita_s.startReceive(1);
    ue_s.setHeaders('A','Z');
    ue_s.startReceive(5);
    debug_button.mode(PullDown);
    while(1)
    {
        debug_led_0 = !debug_led_0;
        to_ue();
        to_sita();
        if(!start)mode = 1;
        if(mode==1&&s_mode ==2)mode = 2;
        if(mode == 2&&u_mode == 0xff &&s_mode == 0xff)mode = 3;
        if(mode == 3&&u_mode == 0xff &&s_mode == 0xff)mode = 5;


    }


    return 0;
}
