#ifndef POSITION_CONTROLLER_H
#define POSITION_CONTROLLER_H

#include "mbed.h"
#define M_PI 3.141592653589793238462643383219502884

class PositionController {
    public :
        PositionController(double accDistance_, double decDistance_, double initialVelocity_, double terminalVelocity_, float maxVelocity_);

        void compute(int positionX, int positionY);
        void targetXY(int targetX_, int targetY_);
        double getVelocityX();
        double getVelocityY();
    private :

        double generateSineWave(double x, double initV, double termV, double start, double length);

        double accDistance;
        double decDistance;
        double accTrue;
        double decTrue;
        double initialVelocity;
        double terminalVelocity;
        float maxVelocity;
        double target;
        int targetX;
        int targetY;
        double radians;
        double velocity[2];

        bool enoughDistance;

        double getVelocity(int position);
};
#endif

