#include "IRsensor.h"

IRsensor::IRsensor(PinName pin):
    a_in(pin)
{
    thread_get_distance.start(callback(this, &IRsensor::threadloop_get_distance));
}

void IRsensor::threadloop_get_distance()
{
    while(true){
        compute_distance();
    }
}

void IRsensor::compute_distance(){
    getInputvoltage();
    changeVtoD();
}

void IRsensor::getInputvoltage(){
    voltage = a_in.read()*3.3f;
}

void IRsensor::changeVtoD()
{
    if (voltage > 2.285f) {
        originaldistance = 0.0f;
    } else if (voltage > 1.645f) {
        originaldistance = -7.8125f * voltage + 27.8515f;
    } else if (voltage > 1.305f) {
        originaldistance = -14.7058f * voltage + 39.1911f;
    } else if (voltage > 1.08f) {
        originaldistance = -22.222f * voltage + 49.0f;
    } else if (voltage > 0.928f) {
        originaldistance = -32.89473f * voltage + 60.526f;
    } else if (voltage > 0.835f) {
        originaldistance = -53.7634f * voltage + 79.89247f;
    } else if (voltage > 0.737f) {
        originaldistance = -51.02040f * voltage + 77.60204f;
    } else if (voltage > 0.673f) {
        originaldistance = -78.12500f * voltage + 97.57812f;
    } else if (voltage > 0.608f) {
        originaldistance = -76.92307f * voltage + 96.76923f;
    } else if (voltage > 0.562f) {
        originaldistance = -108.6956f * voltage + 116.0869f;
    } else if (voltage > 0.515f) {
        originaldistance = -106.3829f * voltage + 114.7872f;
    } else if (voltage > 0.474f) {
        originaldistance = -121.9512f * voltage + 122.8048f;
    } else if (voltage > 0.447f) {
        originaldistance = -185.1851f * voltage + 152.7777f;
    } else if (voltage > 0.432f) {
        originaldistance = -333.333f * voltage + 219.0f;
    } else {
        originaldistance = 9999.9f;
    }
}

void IRsensor::startAveraging(uint8_t averaging_range)
{
    bufferSize = averaging_range;
    data = new float[bufferSize];
    thread_averaging_distance.start(callback(this, &IRsensor::threadloop_averaging_distance));
}
void IRsensor::threadloop_averaging_distance()
{
    while(true){
        computeaverage();
    }    
}
void IRsensor::computeaverage()
{
    bufferpoint++;
    data[bufferpoint % bufferSize] = originaldistance;
    distance_sum = 0;
    for(int i = 0;i<bufferSize;i++)
        distance_sum += data[i];
    distance_average = distance_sum / bufferSize;
}
float IRsensor::getDistance()
{
    return originaldistance;   
}
float IRsensor::get_Averagingdistance()
{
    return distance_average;    
}

float IRsensor::getVoltage()
{
    return voltage;    
}