/**
* @file IRsensor.h
* @brief SHARP 2Y0A21を使ったIR距離測定
*
* Example :
* @code
* #include"mbed.h"
* #include"IRsensor.h"
* 
* IRsensor ir1(PC_1);
*
* Serial pc(USBTX,USBRX,115200);
*
* int main()
* {
*    ir1.startAveraging(255);
*    while(1){
*        float dis = ir1.getDistance();
*        float ave_dis = ir1.get_Averagingdistance();
*        pc.printf("dis:%4.4f[cm]||ave_dis:%4.4f[cm]\n\r",dis,ave_dis);
*        
*    }   
* }
* @endcode
*/

#ifndef IRSENSOR_H
#define IRSENSOE_H

#include"mbed.h"

/**
* @brief SHARP 2Y0A21を使ったIR距離測定のクラス
*/
class IRsensor{
 public:
    /**
     * @brief コンストラクタ
     * @param pin Pint that can do analogin
     */
    IRsensor(PinName pin);
    
    /**
    * @brief センサの値を取得
    * @return voltage
    */
    float getVoltage();
    
    /**
    * @brief センサの値を距離変換し取得
    * @return originaldistance
    */
    float getDistance();
    
    /**
    * @brief 距離の平均化設定
    * @param averaging_range averaging range 1~255
    */
    void startAveraging(uint8_t averaging_range);
    
    /**
    * @brief 平均化した距離を取得
    * @return distance_average
    */
    float get_Averagingdistance();

private:
    void threadloop_get_distance();
    void threadloop_averaging_distance();
    void compute_distance();
    void getInputvoltage();
    void changeVtoD();
    void computeaverage();
    
    float voltage;
    float originaldistance;
    float* data;
    float distance_sum;
    float distance_average;
    uint8_t bufferSize;
    uint8_t bufferpoint;
    Thread thread_get_distance;
    Thread thread_averaging_distance;
    AnalogIn a_in;

};

#endif
