#include "mbed.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

DigitalOut * leds[4];

class Dimmer {
public:
    Dimmer() { 
        counter = 0;
        level = 0;
        which = 0;
    }
    
    void led_dim() {
        *(leds[which]) = ( counter <= level ) ? 1 : 0;
        
        counter++;
        if( counter > 100 ) { 
           counter = 0;
        }
    }
    
    void setLevel(int l) { level = l; }
    void setWhich(int w) { which = w; }
    
private:
    int counter;
    int level;
    int which;
};

int main() {
    leds[0] = &myled1;
    leds[1] = &myled2;
    leds[2] = &myled3;
    leds[3] = &myled4;

    int level = 0;
    int increment = 1;
    int which = 0;
    
    Dimmer dimmer;
    Ticker timer;
    
    timer.attach_us(&dimmer, &Dimmer::led_dim, 20);
    
    while(1) {
        level += increment;
        
        if( level >= 100 ) { 
            which++;
            if( which > 3 ) {
                which = 3;
                increment = -1;
            }
            else {
                level = 0;
            }
            dimmer.setWhich( which );
        }
        else if( level <= 0 ) {
            which--;
            if( which < 0 ) {
                which = 0;
                increment = 1;
            }
            else {
                level = 100;
            }
            dimmer.setWhich( which );
        }
        
        dimmer.setLevel(level);
        wait(0.01);
    }
}
