#include "mbed.h"
#include "USBMouseKeyboard.h"
#include "FXOS8700Q.h"

USBMouseKeyboard key_mouse;                                 // Use USBMouseKeyboard which emulates USB mouse & keyboard
FXOS8700Q_acc acc( PTB3, PTB2, FXOS8700CQ_SLAVE_ADDR2 );    // Use accelerometer
MotionSensorDataUnits acc_data;
DigitalIn sw2(SW2);
DigitalIn sw3(SW3);

int calcMouseMovement(float f) {
    if( f > 0.3f ) {
        // Board is listing to the right or to the front
        return 10;
    } else if( f < -0.3f ) {
        // Board is listing to the left or to the back
        return -10;
    } else {
        return 0;
    }
}

int main(void) {
    
    acc.enable();
    
    while (1) {
        acc.getAxis(acc_data);
        float x = acc_data.x;               // Substitute x for x-axis value of accelerometer
        float y = acc_data.y;               // Substitute y for y-axis value of accelerometer
        
        key_mouse.move(calcMouseMovement(x), 0);    // Move the mouse cursor in x-axis direction
        key_mouse.move(0, calcMouseMovement(-y));   // Move the mouse cursor in y-axis direction
        printf("%f => key_mouse.move(%d, 0)\r\n", x, calcMouseMovement(x));
        printf("%f => key_mouse.move(0, %d)\r\n", y, calcMouseMovement(y));
        
        if( sw2 == 1 ) {
            // SW2 is not pressed
            key_mouse.release(MOUSE_LEFT);  // Release the left button
        } else {
            // SW2 is pressed
            key_mouse.press(MOUSE_LEFT);    // Press the left button
        }
        
        if( sw3 == 1 ) {
            // SW3 is not pressed
            key_mouse.release(MOUSE_RIGHT); // Release the right button
        } else {
            // SW3 is pressed
            key_mouse.press(MOUSE_RIGHT);   // Press the right button
        }
        wait(0.1);
    }
}
