#include "mbed.h"
#include "math.h"
#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"

#define PI 3.14159265358979323846

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;

AnalogIn a1(A1);
AnalogIn a2(A5);

int P1x1 = 0, P1x2 = 3, P1y1 = 100, P1y2;
int P2x1 = 480, P2x2 = 477, P2y1 = 100, P2y2;
float joueur_1;
float joueur_2;

// Fonction pour afficher le jeu

void menu_jeu(void);
void affihage_jeu(void);
void jeu(void);


// Tactile

TS_StateTypeDef TS_State;
uint8_t  init;
int x, y;
uint8_t idx;

//Score des joueurs

uint8_t score_texte[30];
uint8_t score_texte_2[30];
int score_P1 = 0;
int score_P2 = 0;

// Déclaration pour gérer la balle

float bx = 200;
float by = 135;
float speed = 0;
float angle = 25;

// Booleen pour gérer les differents interface

bool start = false;
bool score = false;


//***********************************************************************************

void affichage_jeu()
{

    // Initialisation du jeu
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillCircle(bx, by, 5);
    lcd.DrawRect(10, 10, 350, 260);
    lcd.FillRect(15, P1y1, 5, 40);
    lcd.FillRect(345, P2y1, 5, 40);

    // Inscrire les scores
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.SetFont(& Font20);
    lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"SCORE P1", RIGHT_MODE);
    sprintf((char*)score_texte, "%d", score_P1);
    lcd.DisplayStringAt(0, LINE(3), (uint8_t *)&score_texte, RIGHT_MODE);

    lcd.DisplayStringAt(0, LINE(7), (uint8_t *)"SCORE P2", RIGHT_MODE);
    sprintf((char*)score_texte_2, "%d", score_P2);
    lcd.DisplayStringAt(0, LINE(9), (uint8_t *)&score_texte_2, RIGHT_MODE);

    // Tactile sur le raquette
    while(start == false) {
        ts.GetState(&TS_State);
        x = TS_State.touchX[idx];
        y = TS_State.touchY[idx];

        if (TS_State.touchDetected) {

            if ((x>280) && (x<400) && (y>15) && (y<250)) {
                lcd.SetTextColor(LCD_COLOR_WHITE);
                lcd.FillRect(345, TS_State.touchY[0], 5, 40);
                lcd.DrawRect(10, 10, 350, 260);
                lcd.SetTextColor(LCD_COLOR_BLACK);
                lcd.FillRect(345, 0, 5, TS_State.touchY[0]-1);
                lcd.FillRect(345, TS_State.touchY[0]+40, 5, 100);
            }
        }

        // Tactile sur la nalle pour démarrer le jeu
        if (TS_State.touchDetected) {
            if ( (x>190) && (x<210) && (y>125) && (y<145)) {
                start = true;
                jeu();
            }
        }

        joueur_1 = a1.read();
    //    joueur_2 = a2.read();

        P1y1 = (joueur_1*212+8);
        P1y2 = P1y1 + 40;
    //    P2y1 = (joueur_2*212+8);
    //    P2y2 = P2y1 + 40;

        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.FillRect(15, P1y1, 5, 40);
        lcd.SetTextColor(LCD_COLOR_BLACK);
        lcd.FillRect(15, 0, 5, P1y1-1);
        lcd.FillRect(15, P1y2+1, 5, 200);



    }
}

//***********************************************************************************

//***********************************************************************************
void jeu()

{
    while(score == false) {
        
        

        joueur_1 = a1.read();
     //   joueur_2 = a2.read();

        P1y1 = (joueur_1*212+8);
        P1y2 = P1y1 + 40;
    //   P2y1 = (joueur_2*212+8);
    //    P2y2 = P2y1 + 40;
    
        ts.GetState(&TS_State);
        x = TS_State.touchX[idx];
        y = TS_State.touchY[idx];

        if (TS_State.touchDetected) {

            if ((x>280) && (x<400) && (y>15) && (y<250)) {
                lcd.SetTextColor(LCD_COLOR_WHITE);
                lcd.FillRect(345, TS_State.touchY[0], 5, 40);
                lcd.DrawRect(10, 10, 350, 260);
                lcd.SetTextColor(LCD_COLOR_BLACK);
                lcd.FillRect(345, 0, 5, TS_State.touchY[0]-1);
                lcd.FillRect(345, TS_State.touchY[0]+40, 5, 100);
            }
        }


        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.FillRect(15, P1y1, 5, 40);
        lcd.SetTextColor(LCD_COLOR_BLACK);
        lcd.FillRect(15, 0, 5, P1y1-1);
        lcd.FillRect(15, P1y2+1, 5, 200);


        // Gérer la physique de la balle
        lcd.SetTextColor(LCD_COLOR_BLACK);
        lcd.FillCircle(bx, by, 5);
        wait_ms(5);
        speed = 2;
        bx = bx + speed * cos(angle*2*PI/360);
        by = by - speed * sin(angle*2*PI/360);

        // On gére les rebonds sur les raquettes
        if (((by>TS_State.touchY[0]-5 && by <TS_State.touchY[0]+40) && bx > 340) || ((by>P1y1 && by <P1y2+1) && bx < 25) ) {
            angle = 180-angle;
        } else if ( bx > 360 ) {
            start = false;
            bx = 200;
            by = 135;
            angle = angle+210;
            score_P1++;
            lcd.Clear(LCD_COLOR_BLACK);
            affichage_jeu();
        } else if (bx < 15) {
            start = false;
            bx = 200;
            by = 135;
            angle = angle+210;
            score_P2++;
            lcd.Clear(LCD_COLOR_BLACK);
            affichage_jeu();
        }
        // On gére les rebonds sur les murs
        if (((bx>15 && bx <345) && by > 250) || ((bx>15 && bx <340) && by < 25) ) {
            angle = -angle;
        }

        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.FillCircle(bx, by, 5);
        lcd.FillCircle(bx, by, 5);
        wait_ms(5);

    }
}

//***********************************************************************************

//***********************************************************************************

void menu_jeu()
{
    bool debut_jeu = false;

    lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"PONG", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"Start", CENTER_MODE);

    while(debut_jeu == false) {

        ts.GetState(&TS_State);
        if (TS_State.touchDetected) {

            x = TS_State.touchX[idx];
            y = TS_State.touchY[idx];

            if ((x>195) && (x<255) && (y>110) && (y<155)) {
                lcd.Clear(LCD_COLOR_BLACK);
                affichage_jeu();
                debut_jeu = true;

            }
        }
    }
}

//*********************************************************************************


int main()
{
    init = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    menu_jeu();

    while(1) {


    }
}

//*********************************************************************************
