/*
This program is a quick test of the Outrageous Circuits mBuino using an ENC28J60 Ethernet chip.
This is modified from Zoltan Hudak's MQTT_Hello_ENC28J60 program.
https://developer.mbed.org/users/hudakz/code/MQTT_Hello_ENC28J60/

UIPEthernet and MQTTClient are from Zoltan Hudak as well.

This program connects to an MQTT broker.  Subscribes to two topics and publishes to one of those topics every 5 seconds.
The payload for the published topic are the elapsed milliseconds from a free running timer.  The round trip time is calculated for the published topic to be received.

*/



#include "mbed.h"
#include <UIPEthernet.h>
#include <MQTTClient.h>
#include <UIPClient.h>

DigitalOut myled(LED1);
DigitalOut led2(LED2);
Serial pc(P0_19,P0_18 );

UIPEthernetClass UIPEthernet(P0_21, P0_22, P1_15, P0_11);        // mosi, miso, sck, cs

// MAC number must be unique within the connected network. Modify as appropriate.
const uint8_t    MY_MAC[6] = {0x00,0x01,0x02,0x03,0x04,0x06};
// IP address must be also unique and compatible with your network. Change as appropriate.
const IPAddress  MY_IP(192,168,1,181);
const IPAddress  MY_DNS(192,168,1,1);
const IPAddress  MY_GATEWAY(192,168,1,1);
const IPAddress  MY_MASK(255,255,255,0);

char                message_buff[100];
IPAddress           serverIP(192,168,1,1);  // MQTT broker (e.g. 'Mosquitto' running on a Raspberry Pi or Linux machine)
EthernetClient      ethernetClient;
void                onMqttMessage(char* topic, uint8_t* payload, unsigned int length);
MQTTClient          mqttClient(serverIP, 1883, onMqttMessage, ethernetClient);
Timer       timer;


int main(void)
{
    const int   MAX_COUNT = 5;
    int         i = 0;
    bool        connected = false;
    char       payload[100];
    int         nextTimer = 0;
    bool        led2Status = false;
    pc.baud(19200);
    // initialize the ethernet device

    UIPEthernet.begin(MY_MAC, MY_IP, MY_DNS, MY_GATEWAY, MY_MASK); //uint8_t* mac, IPAddress ip, IPAddress dns, IPAddress gateway, IPAddress subnet

    // The MQTT broker is like a post office distributing messages published by clients to all subscribers (clients).
    // So the 'example/hello' messages published by this client will be sent via the broker to all clients which subscribed to such messages.
    // This way also this client will receive all subscribed messages (in this case 'outdoor/temperature' messages)
    // published by other clients (however not directly but via the broker).
    pc.printf("Connecting to MQTT broker ..\r\n");
    do {
        wait(1.0);
        connected = mqttClient.connect("myMQTTHelloClient");
    } while(!connected && (i < MAX_COUNT));

    if(connected) {
        pc.printf("MQTT broker connected.\r\n");
        mqttClient.subscribe("outdoor/temperature");
        pc.printf("Subscribed to: outdoor/temperature\r\n");
        mqttClient.subscribe("example/hello");
        pc.printf("Subscribed to: example/hello\r\n");
    } else {
        pc.printf("Failed to connect to MQTT broker.\r\n");
    }

    //start global timer
    timer.start();

    while(1) {


        if(timer.read_ms() > nextTimer) {
            nextTimer = timer.read_ms() + 5000;

            if(led2Status == true) {
                led2 = 0;
                led2Status = false;
            } else {
                led2 = 1;
                led2Status = true;
            }
            //lastTime = t;
            if(connected) {
                pc.printf("Publish. . .\r\n");
                sprintf(payload, "%d", timer.read_ms());
                mqttClient.publish("example/hello", payload);
                pc.printf("Published: example/hello\r\n");
            } else {
                pc.printf("Not connected\r\n");
            }
        }

        mqttClient.loop();  // MQTT client loop processing
    }
}

/**
 * @brief   Called on new MQTT message arrival
 * @note
 * @param   topic:      The topic of the new message
 *          payload:    The payload of the new message
 *          length:     Payload's length
 * @retval
 */
void onMqttMessage(char* topic, uint8_t* payload, unsigned int length)
{
    int i = 0;
    int elapsed = 0;
    int value = 0;
    myled = 1;
    //pc.printf("Message arrived:\r\n");
    //pc.printf("  Topic: %s\r\n", topic);
    //pc.printf("  Length: %d\r\n", length);

    // create character buffer with ending null terminator (string)
    for(i = 0; i < length; i++) {
        message_buff[i] = payload[i];
    }

    message_buff[i] = '\0';
    value = atoi(message_buff);
    elapsed = timer.read_ms() - value;
    pc.printf("%d - Payload: %s\r\n", elapsed, message_buff);
    myled = 0;
}