/*
***********************************************************
* DSMI Server sample by RJB@skclabo
*
* Device         : mbed NXP LPC1768 with StarBoard Orange
* Date           : 2010/10/25
* Version        : 0.3 alfa
*
***********************************************************
*/

#include "mbed.h"
#include "TextLCD.h"
#include "EthernetNetIf.h"
#include "UDPSocket.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d0-d3

EthernetNetIf eth;
UDPSocket udp;

DigitalOut ledA(LED1);

Serial SerialMidiDevice(p9, p10);  // tx, rx

unsigned char RxByte;

void onUDPSocketEvent(UDPSocketEvent e)
{
  switch(e)
  {
  case UDPSOCKET_READABLE: //The only event for now
    char buf[64] = {0};
    Host host;
    while( int len = udp.recvfrom( buf, 63, &host ) )
    {
      if( len <= 0 )
        break;
      
      ledA = 1;
      for( int i=0; i<len; i++)
      {
         RxByte = buf[i];
         SerialMidiDevice.putc(RxByte);     /* MIDI_0,1,2... */
//       MidiStreamParser();                /* optional */
      }

      printf("From %d.%d.%d.%d: len %02d: %02X.%02X.%02X\n",
              host.getIp()[0], host.getIp()[1], host.getIp()[2], host.getIp()[3],
              len, buf[0], buf[1], buf[2]);
      ledA = 0;
    }
    break;
  }
}

int main() {

  lcd.cls();
  lcd.locate( 0, 0 );
  lcd.printf("mbed DSMI Server");

  lcd.locate( 0, 1 );
  lcd.printf("StarBoard Orange");
  wait(2.0);

  lcd.locate( 0, 1 );
  lcd.printf("Setting up...   ");
  printf("Setting up...\n");

  SerialMidiDevice.baud(31250);

  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    lcd.locate( 0, 1 );
    lcd.printf("Error in setup.\n");
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");

  printf("IP address %d.%d.%d.%d\n", eth.getIp()[0], eth.getIp()[1], eth.getIp()[2], eth.getIp()[3]);
  Host broadcast(IpAddr(eth.getIp()[0], eth.getIp()[1], eth.getIp()[2], 255), 9000, NULL);
  udp.setOnEvent(&onUDPSocketEvent);
  udp.bind(broadcast);

  lcd.locate( 0, 1 );
  lcd.printf("%03d.%03d.%03d.%03d", eth.getIp()[0], eth.getIp()[1], eth.getIp()[2], eth.getIp()[3]);
  wait(2.0);
  lcd.locate( 0, 1 );
  lcd.printf("Ready!!         ");
  
  while(true)
  {
    Net::poll();
  }
}
