/*TestAnalogInPins: written by Sami Kanderian, last updated on 11 May 2016. It continuously reads
and prints  16 Analog Input Pin voltages on the NPX Freescale FRDM-KL25Z microprocessor board via
serial inputs registered via an RX Interrupt trigger that changes the value of charCCIn, where
charCCIn goes from '00' to '16'. charCCIn should be preceeded by a '#'. Serial baud rate is 9600.
The data acquisition rate whereby voltage readings are updated is defined by the variable updatePeriodMs.

Serial inputs followed by Carriage Return:
'#00': print analog input voltages on all pins (deafault printout on startup)
'#01': print analog input voltage on pin PTE20
'#02': print analog input voltage on pin PTB0 
'#03': print analog input voltage on pin PTB1
'#04': print analog input voltage on pin PTE22
'#05': print analog input voltage on pin PTB2
'#06': print analog input voltage on pin PTE23
'#07': print analog input voltage on pin PTB3
'#08': print analog input voltage on pin PTE29
'#09': print analog input voltage on pin PTC2
'#10': print analog input voltage on pin PTE30
'#11': print analog input voltage on pin PTC1
'#12': print analog input voltage on pin PTC0
'#13': print analog input voltage on pin PTD5
'#14': print analog input voltage on pin PTD6
*/

#include "mbed.h"
#define MAXINT 2147483647
//Declare hardware inputs
Serial serial(USBTX, USBRX);
Timer timer;

//IMPORTANT NOTE: PTA1 and PTA2 ARE RESERVED FOR SERIAL COMMUNICATION VIA SDA USB!!! DO NOT USE FOR SENSOR/ACTUATOR I/O!!! PTD1 IS USED FOR ON BOARD LED
//PTE21 should be 16 bit ADC but doesnt work as ADC on mbed. Instead PTE21 reads whatever analog reading is input to PTE29
//Analog inputs : 0-3.3V
AnalogIn pin1(PTE20);//works as 16 bit ADC
AnalogIn pin2(PTB0); //works as 12 bit ADC
AnalogIn pin3(PTB1); //works as 12 bit ADC
AnalogIn pin4(PTE22);//works as 12 bit ADC
AnalogIn pin5(PTB2);//works as 12 bit ADC
AnalogIn pin6(PTE23);//works as 12 bit ADC
AnalogIn pin7(PTB3); //works as 12 bit ADC
AnalogIn pin8(PTE29);//works as 12 bit ADC
AnalogIn pin9(PTC2);//works as 12 bit ADC
AnalogIn pin10(PTE30);//works as 12 bit ADC
AnalogIn pin11(PTC1);//works as 12 bit ADC
AnalogIn pin12(PTC0);//works as 12 bit ADC
AnalogIn pin13(PTD5);//works as 12 bit ADC
AnalogIn pin14(PTD6);//works as 12 bit ADC

//Built in LEDs
PwmOut rLed(LED_RED);
PwmOut gLed(LED_GREEN);
PwmOut bLed(LED_BLUE);

//New globals for RxInterrupt routine
const int bufferSize = 256;
char rxBuffer[bufferSize];
char txBuffer[bufferSize];
volatile int rxIn = 0;
volatile int rxOut = 0;
bool rxFlag = 0;

//other globals
char charCCIn[3];
int decCCIn=0; //by default, output all analog pins on startup
int updatePeriodMs = 1000;

void ledConfirmSent()//Light up blue LED 10%
{
    rLed = 1;
    gLed = 1;
    bLed = 0.9;
}

void ledConfirmReceive()//Light up green LED 10%
{
    rLed = 1;
    gLed = 0.9;
    bLed = 1;
}

void sendAnalogIn(int pinNum) //send Analog input in V.
//Pin inputs are normalized to have a max value of 1 so a 3.3 multiplier is used to convert back to voltage
{
    if (pinNum == 0 || pinNum == 1) {
        serial.printf("%s%03.1f%s\r\n", "#PTE20: ", 3.3f*pin1.read(), "V");
    }
    if (pinNum == 0 || pinNum == 2) {
        serial.printf("%s%03.1f%s\r\n", "#PTB0: ", 3.3f*pin2.read(), "V");
    }    
    if (pinNum == 0 || pinNum == 3) {
        serial.printf("%s%03.1f%s\r\n", "#PTB1: ", 3.3f*pin3.read(), "V");
    }
    if (pinNum == 0 || pinNum == 4) {
        serial.printf("%s%03.1f%s\r\n", "#PTE22: ", 3.3f*pin4.read(), "V");
    }
    if (pinNum == 0 || pinNum == 5) {
        serial.printf("%s%03.1f%s\r\n", "#PTB2: ", 3.3f*pin5.read(), "V");
    }
    if (pinNum == 0 || pinNum == 6) {
        serial.printf("%s%03.1f%s\r\n", "#PTE23: ", 3.3f*pin6.read(), "V");
    }
    if (pinNum == 0 || pinNum == 7) {
        serial.printf("%s%03.1f%s\r\n", "#PTB3: ", 3.3f*pin7.read(), "V");
    }
    if (pinNum == 0 || pinNum == 8) {
        serial.printf("%s%03.1f%s\r\n", "#PTE29: ", 3.3f*pin8.read(), "V");
    }
    if (pinNum == 0 || pinNum == 9) {
        serial.printf("%s%03.1f%s\r\n", "#PTC2: ", 3.3f*pin9.read(), "V");
    }
    if (pinNum == 0 || pinNum == 10) {
        serial.printf("%s%03.1f%s\r\n", "#PTE30: ", 3.3f*pin10.read(), "V");
    }
    if (pinNum == 0 || pinNum == 11) {
        serial.printf("%s%03.1f%s\r\n", "#PTC1: ", 3.3f*pin11.read(), "V");
    }
    if (pinNum == 0 || pinNum == 12) {
        serial.printf("%s%03.1f%s\r\n", "#PTC0: ", 3.3f*pin12.read(), "V");
    }
    if (pinNum == 0 || pinNum == 13) {
        serial.printf("%s%03.1f%s\r\n", "#PTD5: ", 3.3f*pin13.read(), "V");
    }
    if (pinNum == 0 || pinNum == 14) {
        serial.printf("%s%03.1f%s\r\n", "#PTD6: ", 3.3f*pin14.read(), "V");
    }    
    ledConfirmSent();
}

void runWhenNewSerialIn()
{
    if (rxBuffer[0] !='#') {
        serial.printf("%s\r\n", "Input format should be '#XX'. First input character should be '#'");
        serial.printf("%s\r\n", "followed by XX where XX goes from '00' to '14'");
    }
    for (int i = 0; i < 2; i++) {
        charCCIn[i] = rxBuffer[i+1];
    }
    decCCIn=strtol(charCCIn,NULL,10);// this line converts char to int
    //decCCIn= 10*((int)(charCCIn[0])-48)+ ((int)(charCCIn[1])-48);// equivalent to line above
    serial.printf("%s%d\r\n", "decCCIn=  ",decCCIn);
}

void Rx_interrupt()
{
    // Loop just in case more than one character is in UART's receive FIFO buffer
    // Stop if buffer full
    //while ((serial.readable()) && (((rxIn + 1) % bufferSize) != 0)) {
    while (serial.readable()) {
        rxBuffer[rxIn] = serial.getc();
        if (rxBuffer[rxIn] == '\r') { //looking for character not string (string is double quotes) \r is CR, \n is LF
            rxFlag = 1;
            //Turn built in LED blue (at half intensity) to confirm command recieved
            ledConfirmReceive();
        } else {
            rxIn = (rxIn + 1) % bufferSize;
        }
    }
}

int main()
{
    serial.baud(9600);
    serial.attach(&Rx_interrupt, Serial::RxIrq);
    timer.start();
    int startFnTimeUs;
    int lastActionTimeUs=timer.read_us();

    int updatePeriodUs = updatePeriodMs*1000;

    while (1) {
        startFnTimeUs = timer.read_us();
        if (rxFlag==1) {
            runWhenNewSerialIn();
            rxFlag = 0; //reset flag to listen for next message
            rxIn = 0;   //reset position index to 0
        }
        int timeChangeUs = (startFnTimeUs - lastActionTimeUs);
        if (timeChangeUs<0) { //IMPOTRANT!! This handles wrapping of timer when it exceeds MAXINT and goes slightly above zero resulting in a negative timeChangeUs
            timeChangeUs=timeChangeUs + MAXINT +1;
        }
        if (timeChangeUs >= updatePeriodUs) {//Prefer never to use wait in loop in priciple as it hangs processor from doing other tasks when necessary
            //Run sendAnalogIn if elapsed time has passed. New decCCIn is registered with new serial input
            sendAnalogIn(decCCIn);                     
            lastActionTimeUs=startFnTimeUs;        
        }
    }
}