/*Can not independently PWM control pins PTA5 and PTD2.
When pins PTA5 and PTD2 are declared as PwmOut pins, they are locked together and can not be independently controlled.
This code should keep pin PTD2 at 0% pwm while pin PTA5 should switch between 50% and 0% every 0.5 seconds.
Pin PTA5 does alternate between 50% and 0% pwm, but instead of staying at 0% pwm, pin PTD2 follows pin PTA5.
by Sami Kanderian 7/8/2016
*/
#include "mbed.h"

PwmOut pwmPelCooler(PTA5);
PwmOut pwmCapHeater(PTD2);

int main()
{
    double dt=0.5f;
    pwmPelCooler.period(0.001f);
    pwmCapHeater.period(0.001f);
    wait(0.5);
    pwmPelCooler=0.5f;
    pwmCapHeater=0.0f;
    bool mySwitch = false;
    while(true) {

        mySwitch=!mySwitch;
        if (mySwitch) {
            pwmPelCooler=0.5f;
        } else {
            pwmPelCooler=0.0f;
        }
        wait(dt);
    }
}