#include "mbed.h"

#define RPR0521_MODE_CONT_CONTENT (0xC6u) // Temperature Register
#define RPR0521_MODE_CONT         (0x41u) // Configuration Register
#define BH1745_SAD              (0x38u)   // BH1745 address
#define BH1745_SYSTEM_CONTROL   (0x40u)
#define BH1745_MODE_CONTROL1    (0x41u)
#define BH1745_MODE_CONTROL2    (0x42u)
#define BH1745_MODE_CONTROL3    (0x43u)
#define BH1745_PERSISTANT       (0x61u)
#define BH1745_CLEAR_LSB        (0x56u)
 
I2C i2c(I2C_SDA, I2C_SCL);
DigitalOut myled(LED1);

/* Simple Hello World program that outputs "Hello World!" every 
    five seconds to the serial debug port, and blinks at the user
    defined hertz
*/

// LED blink rate: higher -> faster blinking
#define LED_BLINK_RATE 18  //Hertz

//Define the LED pin output
//DigitalOut data00(D0); 
DigitalOut data00(PA_3);     //Blinds D0 LED
//DigitalOut data01(D1);
DigitalOut data01(PA_2);     //Blinds D1 LED
//DigitalOut data02(D2);
//DigitalOut data02(PB_15);    //Blinds D2 LED
//DigitalOut data03(D3);
DigitalOut data03(PA_0);     //Blinds D3 LED
//DigitalOut data04(D4);
DigitalOut data04(PA_7);     //Blinds D4 LED
//DigitalOut data05(D5);
DigitalOut data05(PA_9);     //Blinds D5 LED
//DigitalOut data06(D6);
DigitalOut data06(PA_1);     //Blinds D6 LED
//DigitalOut data07(D7);
DigitalOut data07(PA_8);     //Blinds D7 LED
//DigitalOut data08(D8); 
DigitalOut data08(PB_1);     //Blinds D8 LED
int temp;

//Define timers
Timer print_timer;
Timer led_timer;

int main() {
    data00 = 1;                            //Initialize LED off
    data01 = 1;                            //Initialize LED off
//    data02 = 1;                            //Initialize LED off
    data03 = 1;                            //Initialize LED off
    data04 = 1;                            //Initialize LED off
    data05 = 1;                            //Initialize LED off
    data06 = 1;                            //Initialize LED off
    data07 = 1;                            //Initialize LED off
    data08 = 0;                            //Initialize LED off
    print_timer.start();                //Start timers, will count until stopped
    led_timer.start();
    
    
    // Configure I2C **********************************************************
    char data_write[2];
    char data_read[6];
 
    /* Configure the Temperature sensor device STLM75:
    - Thermostat mode Interrupt
    - Fault tolerance: 0
    */
      
    data_write[0] = BH1745_PERSISTANT;
    data_write[1] = 0x03u; 
    int status = i2c.write(BH1745_SAD, data_write, 2, 0);
    if (status != 0) { // Error
        while (1) {
            myled = !myled;
            wait(0.7);
        }
    }
    
    data_write[0] = BH1745_MODE_CONTROL1;
    data_write[1] = 0x05u; 
    status = i2c.write(BH1745_SAD, data_write, 2, 0);
    if (status != 0) { // Error
        while (1) {
            myled = !myled;
            wait(0.7);
        }
    }
    
    data_write[0] = BH1745_MODE_CONTROL2;
    data_write[1] = 0x92u; 
    status = i2c.write(BH1745_SAD, data_write, 2, 0);
    if (status != 0) { // Error
        while (1) {
            myled = !myled;
            wait(0.7);
        }
    }
    
    data_write[0] = BH1745_MODE_CONTROL3;
    data_write[1] = 0x02u; 
    status = i2c.write(BH1745_SAD, data_write, 2, 0);
    if (status != 0) { // Error
        while (1) {
            myled = !myled;
            wait(0.7);
        }
    }
    
    // *************************************************************************
    while (1) {
        // I2C Routines *******************************************************
        // Read temperature register
        data_write[0] = BH1745_SYSTEM_CONTROL;
        i2c.write(BH1745_SAD, data_write, 1, 1); // no stop
        i2c.read(BH1745_SAD, data_read, 6, 0);
    
        // Calculate temperature value in Celcius 
        int tempval1 = (int)data_read[0];
        int tempval2 = (int)data_read[1];
        int tempval3 = (int)data_read[2];
        int tempval4 = (int)data_read[3];
        int tempval5 = (int)data_read[4];
        int tempval6 = (int)data_read[5];
        /*
        tempval >>= 7;
        if (tempval <= 256) {
            TempCelsiusDisplay[0] = '+';
        } else {
            TempCelsiusDisplay[0] = '-';
            tempval = 512 - tempval;
        }*/
 
        // Decimal part (0.5°C precision)
        /*
        if (tempval & 0x01) {
            TempCelsiusDisplay[5] = 0x05 + 0x30;
        } else {
            TempCelsiusDisplay[5] = 0x00 + 0x30;
        }
        */
 
        // Integer part
        /*
        tempval >>= 1;
        TempCelsiusDisplay[1] = (tempval / 100) + 0x30;
        TempCelsiusDisplay[2] = ((tempval % 100) / 10) + 0x30;
        TempCelsiusDisplay[3] = ((tempval % 100) % 10) + 0x30;
 
        // Display result
        pc.printf("temp = %s\n", TempCelsiusDisplay);
        myled = !myled;
        wait(1.0);
        */
     
        //*********************************************************************
 
        // UART
        if (print_timer.read() >= 1) {  //print_timer.read() returns time in seconds
            printf("Francis' Test: %d, %d, %d, %d. %d, %d!\n",tempval1,tempval2,tempval3,tempval4,tempval5,tempval6);
            print_timer.reset();        //Resets timer count to 0
        }
        
        // GPIO OUT
        //Calculates interval needed for specified frequency
        if ( led_timer.read_ms() >= (2000.0/(2*LED_BLINK_RATE))) {     
            temp   =  data01;                 //Invert LED output
            data01 =  data00;                 //Invert LED output
            data00 =  data03;                 //Invert LED output
            data03 =  data06;                 //Invert LED output
            data06 =  data08;                 //Invert LED output
            data08 =  data05;                 //Invert LED output
            data05 =  data04;                 //Invert LED output
            data04 =  data07;                 //Invert LED output
            data07 =  temp;                   //Invert LED output
            led_timer.reset();          //Resets timer count to 0
        }
    }
}


