/* 
 * mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
 //BALLOON GAME!
 /*
 *  Code Example for ROHM Sensor Expo Balloon Game
 * 
 *  Description: This Application interfaces ROHM's BM1383AGLV with Nordic's nRF51-DK
 *  This Code supports the following sensor devices:
 *      > BM1383AGLV Pressure Sensor
 *
 *  This Code allows the user to configure two known pressure distances and save pressure readings
 *  onto the application.  Then it will automatically extrapolate these values and allow the user to see
 *  the height of the board.  When connected to a balloon, greater heights can be achieved and the board
 *  will return the current height of the board.
 * 
 *  Last Upadtaed: 6/19/2016 
 *  Author: ROHM USDC
 *  Contact Information: engineering@rohmsemiconductor.com
 *  GitHub Link: https://github.com/ROHMUSDC/ROHM-SensorExpo2016-Pressure-Sensor-Demo/
 *  MBED Repository Link: https://developer.mbed.org/teams/ROHMUSDC/code/ROHMSensorShield_BALLOONGAME/
 */

//#define nRF52DevKit         //Comment out and change target to Nordic NRf51822 for DemoBoard.  Comment in and change target to Nordic nRF51-DK for Nordic DK Board (and ROHM SHLD0 or SHLD1)
//#define NRFDK               //Comment out and change target to Nordic NRf51822 for DemoBoard.  Comment in and change target to Nordic nRF51-DK for Nordic DK Board (and ROHM SHLD0 or SHLD1)
#define Pressure            //BM1383, Barometric Pressure Sensor
#define BM1383A             //Comment in for SHLD1. Comment out for SHLD0 and DemoBoard.
#define LED_EN
#define BH1745                                 
#define KX022

#include "mbed.h"
#include "BLEDevice.h"
#include "UARTService.h"
#include "nrf_temp.h"
#include "I2C.h"
#include <string>

#define MAX_REPLY_LEN           (UARTService::BLE_UART_SERVICE_MAX_DATA_LEN)    //Actually equal to 20
#define SENSOR_READ_INTERVAL_S  (1.0F) 
#define ADV_INTERVAL_MS         (1000UL)
#define UART_BAUD_RATE          (19200UL)
#define DEVICE_NAME             ("ROHM DEMO  ") // This can be read AFTER connecting to the device.
#define SHORT_NAME              ("BALLOON1")    // Keep this short: max 8 chars if a 128bit UUID is also advertised.
#define DEBUG(...)              { m_serial_port.printf(__VA_ARGS__); }

// Function Prototypes
void PBTrigger();               //Interrupt function for PB4
void BTLE_DataWrittenHandler();

// Global Variables
BLEDevice   m_ble;
Serial      m_serial_port(p9, p11);  // TX pin, RX pin Original
//Serial      m_serial_port(p8, p10);  // TX pin, RX pin 
DigitalOut  m_cmd_led(LED1);
DigitalOut  m_error_led(LED2);

#ifdef LED_EN
PwmOut      BlueLED(p14); // BlueLED Out
PwmOut      GreenLED(p15); // GreenLED
PwmOut      RedLED(p16); //Speed Output
#endif

UARTService *m_uart_service_ptr;
DigitalIn   testButton(p20);
InterruptIn sw4Press(p20);
#ifdef NRFDK
I2C         i2c(p30,p7);
#endif
#ifndef NRFDK
I2C         i2c(p7,p30);
#endif
bool        RepStart = true;
bool        NoRepStart = false;
int         i = 1;
unsigned char   printQue = 0;
string      ReceivedValue;
char        FormattedData[30];
uint8_t     buf[MAX_REPLY_LEN];
uint32_t    len = 0;

//Sensor Variables
#ifdef Pressure
int         Press_addr_w = 0xBA;
int         Press_addr_r = 0xBB;

char        Press_Content_ReadData[6];
#ifdef BM1383A
char        Press_Addr_ReadData =0x1A;
char        PWR_ON[2] = {0x12, 0x01};
char        PWR_OFF[2] = {0x12, 0x00};
char        SLEEP_OFF[2] = {0x13, 0x01};
char        SLEEP_ON[2] = {0x13, 0x00};
char        Mode_Control[2] = {0x14, 0xCA};
#endif
#ifndef BM1383A
char        Press_Addr_ReadData =0x1C;
char        PWR_DOWN[2] = {0x12, 0x01};
char        SLEEP[2] = {0x13, 0x01};
char        Mode_Control[2] = {0x14, 0xC4}; 
#endif

int         BM1383_Temp_highByte;
int         BM1383_Temp_lowByte;
int         BM1383_Pres_highByte;
int         BM1383_Pres_lowByte;
int         BM1383_Pres_leastByte; 

short int   BM1383_Temp_Out;
float       BM1383_Temp_Conv_Out;
float       BM1383_Pres_Conv_Out;

float       BM1383_Var;
float       BM1383_Deci;

uint32_t    BM1383_TempPressure;


#endif
#ifdef BH1745
int         BH1745_addr_w = 0x72;
int         BH1745_addr_r = 0x73;

char        BH1745_CTRL2[2] = {0x42, 0x11};  

char        BH1745_Content_ReadData[8]; 
char        BH1745_Content_RED_ReadData[2];   
char        BH1745_Content_GREEN_ReadData[2];   
char        BH1745_Content_BLUE_ReadData[2];   
char        BH1745_Content_CLEAR_ReadData[2];          

float       BH1745_Red;
float       BH1745_Green;
float       BH1745_Blue;
float       BH1745_Clear;

float       SUM_BH1745_Red[10];
float       SUM_BH1745_Green[10];
float       SUM_BH1745_Blue[10];
float       SUM_BH1745_Clear[10];

double      colorSum;
int         colorNum;

unsigned short   BH1745_Raw_R = 0;
unsigned short   BH1745_Raw_G = 0;
unsigned short   BH1745_Raw_B = 0; 
short int   BH1745_Raw_C = 0; 

char        BH1745_Red_Data_LSB = 0x50;    
char        BH1745_GREEN_Data_LSB = 0x52;    
char        BH1745_BLUE_Data_LSB = 0x54;    
char        BH1745_CLEAR_Data_LSB = 0x56;    


            int sampleNum=0;
            char message[20];
            float rValue, gValue, bValue, cValue;
            
            float colorError; 
#endif

#ifdef KX022
int         KX022_addr_w = 0x3C;
int         KX022_addr_r = 0x3D;

char        KX022_Accel_CNTL1_CNTL[2] = {0x18, 0x00};
char        KX022_Accel_ODCNTL[2] = {0x1B, 0x02};
char        KX022_Accel_CNTL1_OPER[2] = {0x18, 0x80};
//char        KX022_Accel_CNTL3[2] = {0x1A, 0xD8};
//char        KX022_Accel_TILT_TIMER[2] = {0x22, 0x01};
//char        KX022_Accel_CNTL2[2] = {0x18, 0xC1};

char        KX022_Content_ReadData[6];
char        KX022_Addr_Accel_ReadData = 0x06;           

float       KX022_Accel_X;
float       KX022_Accel_Y;                               
float       KX022_Accel_Z;

int16_t     KX022_Accel_X_RawOUT = 0;
int16_t     KX022_Accel_Y_RawOUT = 0;
int16_t     KX022_Accel_Z_RawOUT = 0;

int         KX022_Accel_X_LB = 0;
int         KX022_Accel_X_HB = 0;
int         KX022_Accel_Y_LB = 0;
int         KX022_Accel_Y_HB = 0;
int         KX022_Accel_Z_LB = 0;
int         KX022_Accel_Z_HB = 0;

int         lockAccelSum,prevLockAccelSum, isAccelDiffCounter;
int8_t      isAlarmTrig;
int8_t      initConnect;
#endif

//Balloon Game Variables
            
            bool swapped;
            int  n;
            float buffer[80];
            float tempS;
            float initial_P;
            float final_P;
            float lengthMeter;
            unsigned char debugEnable = 0;
            unsigned char isCalibrated = 0; 
            unsigned char isMessageDisplayed = 0;
            unsigned int feet, inches;
            unsigned int gainFactor;
            float inchConversionCoefficient=300.0;
            unsigned int bufferSize = 80;
float       BM1383_Pres_0Level;
float       BM1383_Pres_KnownLevel;
float       HeightBase = 0;
float       HeightKnown_Total = 68;
float       HeightKnown_Foot = 60;
float       HeightKnown_Inches = 8;
float       slope;
float       yInt;
float       pressureCurr;
float       HeightExtrapolated; //Assuming linear pressure curve
float       HeightExtrapolated_Foot = 60;
float       HeightExtrapolated_Inches = 8;


/**
 * This callback is used whenever a disconnection occurs.
 */
void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    isCalibrated = 0; 
    switch (reason) {
    case Gap::REMOTE_USER_TERMINATED_CONNECTION:
        DEBUG("Disconnected (REMOTE_USER_TERMINATED_CONNECTION)\n\r");
        break;
    case Gap::LOCAL_HOST_TERMINATED_CONNECTION:
        DEBUG("Disconnected (LOCAL_HOST_TERMINATED_CONNECTION)\n\r");
        break;
    case Gap::CONN_INTERVAL_UNACCEPTABLE:
        DEBUG("Disconnected (CONN_INTERVAL_UNACCEPTABLE)\n\r");
        break;
    }

    DEBUG("Restarting the advertising process\n\r");
    m_ble.startAdvertising();
}

/**
 * This callback is used whenever the host writes data to one of our GATT characteristics.
 */
void dataWrittenCallback(const GattCharacteristicWriteCBParams *params)
{
    // Ensure that initialization is finished and the host has written to the TX characteristic.
    if ((m_uart_service_ptr != NULL) && (params->charHandle == m_uart_service_ptr->getTXCharacteristicHandle())) {
        int i;
        ReceivedValue.clear();
        for(i = 0; i < params->len; i++)
        {
            ReceivedValue += params->data[i];
        }
        printQue = 1; 
        //if(ReceivedValue[0] == '1')
        //        isCalibrated = 1; 
    }
}

/**
 * This callback is used whenever a write to a GATT characteristic causes data to be sent to the host.
 */
void dataSentCallback(unsigned count)
{
    // NOTE: The count always seems to be 1 regardless of data.
    DEBUG("%d bytes sent to host\n\r", count);
}


/**
 * This callback is scheduled to be called periodically via a low-priority interrupt.
 */
void periodicCallback(void)
{
    //uint8_t  buf[MAX_REPLY_LEN];
    //uint32_t len = 0;
}

void error(ble_error_t err, uint32_t line)
{
    m_error_led = 1;
    DEBUG("Error %d on line number %d\n\r", err, line);
}

void PBTrigger()
{
    uint8_t  buf[MAX_REPLY_LEN];
    uint32_t len = 0;
    
    m_cmd_led = !m_cmd_led;
    
    if (m_ble.getGapState().connected) {
        len = snprintf((char*) buf, MAX_REPLY_LEN, "Button Pressed!");
        m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
    }
}

int main(void)
{
    ble_error_t err;
    Ticker      ticker;

    m_serial_port.baud(UART_BAUD_RATE);

    DEBUG("Initialising...\n\r");

    m_cmd_led      = 0;
    m_error_led    = 0;

    ticker.attach(periodicCallback, SENSOR_READ_INTERVAL_S);

    sw4Press.fall(&PBTrigger);

    #ifdef BH1745
    i2c.write(BH1745_addr_w, &BH1745_CTRL2[0], 2, false); 
    #endif
    
    #ifdef Pressure  //no Initialization because we keep in low power mode until we need to measure pressure
    //i2c.write(Press_addr_w, &PWR_OFF[0], 2, false);
    //i2c.write(Press_addr_w, &SLEEP_ON[0], 2, false);
    //i2c.write(Press_addr_w, &Mode_Control[0], 2, false);
    #endif

    #ifndef BM1383A
    i2c.write(Press_addr_w, &PWR_DOWN[0], 2, false);
    i2c.write(Press_addr_w, &SLEEP[0], 2, false);
    i2c.write(Press_addr_w, &Mode_Control[0], 2, false);
    #endif
    
    #ifdef KX022
    i2c.write(KX022_addr_w, &KX022_Accel_CNTL1_CNTL[0], 2, false);
    i2c.write(KX022_addr_w, &KX022_Accel_ODCNTL[0], 2, false);
    i2c.write(KX022_addr_w, &KX022_Accel_CNTL1_OPER[0], 2, false); 
    #endif
    //Start BTLE Initialization Section
    m_ble.init();
    m_ble.onDisconnection(disconnectionCallback);
    m_ble.onDataWritten(dataWrittenCallback);
    m_ble.onDataSent(dataSentCallback);

    // Set the TX power in dBm units.
    // Possible values (in decreasing order): 4, 0, -4, -8, -12, -16, -20.
    err = m_ble.setTxPower(4);
    if (BLE_ERROR_NONE != err) {
        error(err, __LINE__);
    }

    // Setup advertising (GAP stuff).
    err = m_ble.setDeviceName(DEVICE_NAME);
    if (BLE_ERROR_NONE != err) {
        error(err, __LINE__);
    }

    err = m_ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    if (BLE_ERROR_NONE != err) {
        error(err, __LINE__);
    }

    m_ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);

    err = m_ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                                (const uint8_t *)SHORT_NAME,
                                                (sizeof(SHORT_NAME) - 1));
    if (BLE_ERROR_NONE != err) {
        error(err, __LINE__);
    }

    err = m_ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                                (const uint8_t *)UARTServiceUUID_reversed,
                                                sizeof(UARTServiceUUID_reversed));
    if (BLE_ERROR_NONE != err) {
        error(err, __LINE__);
    }

    m_ble.setAdvertisingInterval(Gap::MSEC_TO_ADVERTISEMENT_DURATION_UNITS(ADV_INTERVAL_MS));
    m_ble.startAdvertising();
 
    
    #ifdef LED_EN 
    //Initialize PWM Output
    BlueLED.period_us(1000);
    BlueLED.pulsewidth_us(1000);
    wait_ms(50);
    BlueLED.pulsewidth_us(0);
    GreenLED.period_us(1000); 
    GreenLED.pulsewidth_us(1000);
    wait_ms(50);
    GreenLED.pulsewidth_us(0);
    RedLED.period_us(1000);
    RedLED.pulsewidth_us(1000);
    wait_ms(50);
    RedLED.pulsewidth_us(0);
    #endif
    // Create a UARTService object (GATT stuff).
    UARTService uartService(m_ble);
    m_uart_service_ptr = &uartService;
    while(!m_ble.getGapState().connected); 
    wait(1); 
    len = snprintf((char*) buf, MAX_REPLY_LEN, "Rohm Semiconductor");
    m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
    len = snprintf((char*) buf, MAX_REPLY_LEN, "Sensors EVK");
    m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
    wait(1); 
    len = snprintf((char*) buf, MAX_REPLY_LEN, "All outputs are");
    m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
    len = snprintf((char*) buf, MAX_REPLY_LEN, "not normalized.");
    m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
    wait(1); 
    len = snprintf((char*) buf, MAX_REPLY_LEN, "For design resources,");
    m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
    len = snprintf((char*) buf, MAX_REPLY_LEN, "Visit GITHUB:");
    m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
    wait(1); 
    len = snprintf((char*) buf, MAX_REPLY_LEN, "ROHMUSDC/ROHM-");
    m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
    len = snprintf((char*) buf, MAX_REPLY_LEN, "SensorExpo2016");
    m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
    wait(1); 
    len = snprintf((char*) buf, MAX_REPLY_LEN, "       ");
    m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
    len = snprintf((char*) buf, MAX_REPLY_LEN, "BM1383: Press '1'");
    m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
    len = snprintf((char*) buf, MAX_REPLY_LEN, "BH1745: Press '2'");
    m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len); 
    len = snprintf((char*) buf, MAX_REPLY_LEN, "KX122:  Press '3'");
    m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
     
    #ifdef LED_EN 
    //Initialize PWM Output
    BlueLED.period_us(1000);
    BlueLED.pulsewidth_us(1000);
    wait_ms(50);
    BlueLED.pulsewidth_us(0);
    GreenLED.period_us(1000); 
    GreenLED.pulsewidth_us(1000);
    wait_ms(50);
    GreenLED.pulsewidth_us(0);
    RedLED.period_us(1000);
    RedLED.pulsewidth_us(1000);
    wait_ms(50);
    RedLED.pulsewidth_us(0);
    #endif
    isCalibrated = 0; 
    wait(1);
    
    isCalibrated = 1;
    
    inchConversionCoefficient = 300.0;
    while (true) {
        m_ble.waitForEvent();
        
        if(m_ble.getGapState().connected){ 
                   
                //***************************** BM1383 **********************************
                    pressureCurr = 0;
                    #ifdef BM1383A
                    i2c.write(Press_addr_w, &PWR_ON[0], 2, false);
                    i2c.write(Press_addr_w, &SLEEP_OFF[0], 2, false);
                    i2c.write(Press_addr_w, &Mode_Control[0], 2, false);
                    #endif 
                    Press_Content_ReadData[0] = 0;
                    Press_Content_ReadData[1] = 0;
                    Press_Content_ReadData[2] = 0;   
                    #ifdef Pressure
                        wait_ms(500);
                        i2c.write(Press_addr_w, &Press_Addr_ReadData, 1, RepStart);
                        i2c.read(Press_addr_r, &Press_Content_ReadData[0], 3, NoRepStart);
                        BM1383_TempPressure = (Press_Content_ReadData[0]<<14)|(Press_Content_ReadData[1]<<6)|(Press_Content_ReadData[2]);
                        BM1383_Pres_Conv_Out = (float)BM1383_TempPressure / (float)2048;
                        wait_ms(500);
                    #endif
                          
                    #ifdef BM1383A
                    //i2c.write(Press_addr_w, &PWR_OFF[0], 2, false);
                    //i2c.write(Press_addr_w, &SLEEP_ON[0], 2, false);
                    #endif  
                //*************************************************************************
                 
                
                
                //***************************** BH1745 **********************************
                #ifdef BH1745
                i2c.write(BH1745_addr_w, &BH1745_Red_Data_LSB, 1, RepStart);
                i2c.read(BH1745_addr_r, &BH1745_Content_ReadData[0], 8, NoRepStart);
                //reconfigure the data (taken from arduino code)
                BH1745_Raw_R = (BH1745_Content_ReadData[1]<<8) | (BH1745_Content_ReadData[0]);
                BH1745_Raw_G = (BH1745_Content_ReadData[3]<<8) | (BH1745_Content_ReadData[2]);
                BH1745_Raw_B = (BH1745_Content_ReadData[5]<<8) | (BH1745_Content_ReadData[4]);  
                BH1745_Raw_C = (BH1745_Content_ReadData[7]<<8) | (BH1745_Content_ReadData[6]);       
          
                BH1745_Red = (float)BH1745_Raw_R / 16384; 
                BH1745_Green = (float)BH1745_Raw_G / 16384; 
                BH1745_Blue = (float)BH1745_Raw_B / 16384; 
                BH1745_Clear = (float)BH1745_Raw_C / 16384;  
                #endif
                //*************************************************************************
                
                
                
                #ifdef KX022
                //---------------------------- KX022 ----------------------------
                //Read KX022 Portion from the IC
                i2c.write(KX022_addr_w, &KX022_Addr_Accel_ReadData, 1, RepStart);
                i2c.read(KX022_addr_r, &KX022_Content_ReadData[0], 6, NoRepStart);
                    
                //reconfigure the data (taken from arduino code)
                KX022_Accel_X_RawOUT = (KX022_Content_ReadData[1]<<8) | (KX022_Content_ReadData[0]) ;
                KX022_Accel_Y_RawOUT = (KX022_Content_ReadData[3]<<8) | (KX022_Content_ReadData[2]) ;
                KX022_Accel_Z_RawOUT = (KX022_Content_ReadData[5]<<8) | (KX022_Content_ReadData[4]) ;  
                //apply needed changes (taken from arduino code)
                KX022_Accel_X = (float)KX022_Accel_X_RawOUT / 16384;
                KX022_Accel_Y = (float)KX022_Accel_Y_RawOUT / 16384;
                KX022_Accel_Z = (float)KX022_Accel_Z_RawOUT / 16384; 
                //----------------------------------------------------------------
                #endif
                /*
                #ifdef LED_EN 
                //Initialize PWM Output
                BlueLED.period_us(1000);
                BlueLED.pulsewidth_us(1000);
                wait_ms(50);
                BlueLED.pulsewidth_us(0);
                GreenLED.period_us(1000); 
                GreenLED.pulsewidth_us(1000);
                wait_ms(50);
                GreenLED.pulsewidth_us(0);
                RedLED.period_us(1000);
                RedLED.pulsewidth_us(1000);
                wait_ms(50);
                RedLED.pulsewidth_us(0);
                #endif
                wait_ms(50);
                */
        } 
        else{
            NVIC_SystemReset();
        }
        
        if(printQue)    //Handle Data Written Interrupt
        {
            #ifdef LED_EN 
            //Initialize PWM Output 
            BlueLED.pulsewidth_us(1000);
            wait_ms(50);
            BlueLED.pulsewidth_us(0); 
            GreenLED.pulsewidth_us(1000);
            wait_ms(50);
            GreenLED.pulsewidth_us(0); 
            RedLED.pulsewidth_us(1000);
            wait_ms(50);
            RedLED.pulsewidth_us(0);
            #endif
            BTLE_DataWrittenHandler();
            printQue = 0;
        }
    }
}

void BTLE_DataWrittenHandler(){    
    int i;
    if (ReceivedValue.length() == 1) {
        switch (ReceivedValue[0]) {  
            case '1':  
                len = snprintf((char*) buf, MAX_REPLY_LEN, "*****************");
                m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len); 
                len = snprintf((char*) buf, MAX_REPLY_LEN, "> Pres= %0.3f hpa", BM1383_Pres_Conv_Out);
                m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len); 
                len = snprintf((char*) buf, MAX_REPLY_LEN, "*****************");
                m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len); 
                break;
            case '2': 
                 #ifdef BH1745
                len = snprintf((char*) buf, MAX_REPLY_LEN,"*****************");
                m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len); 
                len = snprintf((char*) buf,MAX_REPLY_LEN, "> Red     = %0.2f", BH1745_Red*1000); 
                m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
                len = snprintf((char*) buf,MAX_REPLY_LEN, "> Green = %0.2f", BH1745_Green*1000); 
                m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
                len = snprintf((char*) buf,MAX_REPLY_LEN, "> Blue    = %0.2f", BH1745_Blue*1000); 
                m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
                len = snprintf((char*) buf,MAX_REPLY_LEN, "> Clear  = %0.2f", BH1745_Clear*1000);
                m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len); 
                len = snprintf((char*) buf, MAX_REPLY_LEN,"*****************");
                m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len); 
                #endif
                break;
            case '3':
                #ifdef KX022 
                len = snprintf((char*) buf, MAX_REPLY_LEN,"*****************");
                m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len); 
                len = snprintf((char*) buf,MAX_REPLY_LEN, "> AccelX  = %0.2f", KX022_Accel_X);
                m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len); 
                len = snprintf((char*) buf,MAX_REPLY_LEN, "> AccelY  = %0.2f", KX022_Accel_Y);
                m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len); 
                len = snprintf((char*) buf,MAX_REPLY_LEN, "> AccelZ  = %0.2f", KX022_Accel_Z);
                m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len); 
                len = snprintf((char*) buf, MAX_REPLY_LEN,"*****************");
                m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len); 
                #endif
                break;
            case 'x': //System Reset
                NVIC_SystemReset(); //Q. What is this? no break statement?
                                    //A. SoftReset... No need for break because this resets the program...
                break;
                
            default:
                len = snprintf((char*) buf, MAX_REPLY_LEN, "1b,ERROR");
                m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
                break;
        }
    } 
    wait_ms(1000);
    len = snprintf((char*) buf, MAX_REPLY_LEN, "BM1383: Press '1'");
    m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
    len = snprintf((char*) buf, MAX_REPLY_LEN, "BH1745: Press '2'");
    m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len); 
    len = snprintf((char*) buf, MAX_REPLY_LEN, "KX122:  Press '3'");
    m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
  
    /*
    else if (ReceivedValue.length() > 1) {
        
        //BTLE Interface Code, Added 5/29/2016
        for(i = 0; i < 29; i++)
        {
            FormattedData[i] = '\0';
        }
        
        if(ReceivedValue.compare(0,4,"CAL0") == 0)
        {
        }
        
        else if(ReceivedValue.compare(0,4,"CAL1") == 0)
        {               
        }
        
        else if(ReceivedValue.compare(0,4,"HEI?") == 0)
        {
            HeightKnown_Total = HeightKnown_Foot + HeightKnown_Inches;
            slope = (HeightKnown_Total - HeightBase) / (BM1383_Pres_KnownLevel - BM1383_Pres_0Level);
            yInt = HeightBase - (slope * BM1383_Pres_0Level);
            pressureCurr = 0;
            #ifdef BM1383A
            i2c.write(Press_addr_w, &PWR_ON[0], 2, false);
            i2c.write(Press_addr_w, &SLEEP_OFF[0], 2, false);
            i2c.write(Press_addr_w, &Mode_Control[0], 2, false);
            #endif
            #ifndef BM1383A
            //i2c.write(Press_addr_w, &PWR_DOWN[0], 2, false);
            //i2c.write(Press_addr_w, &SLEEP[0], 2, false);
            //i2c.write(Press_addr_w, &Mode_Control[0], 2, false);
            #endif
            Press_Content_ReadData[0] = 0;
            Press_Content_ReadData[1] = 0;
            Press_Content_ReadData[2] = 0;
            for(i = 0; i < 10; i++)
            {
                #ifdef Pressure
                wait_ms(200);
                i2c.write(Press_addr_w, &Press_Addr_ReadData, 1, RepStart);
                i2c.read(Press_addr_r, &Press_Content_ReadData[0], 3, NoRepStart);
                BM1383_TempPressure = (Press_Content_ReadData[0]<<14)|(Press_Content_ReadData[1]<<6)|(Press_Content_ReadData[2]);
                BM1383_Pres_Conv_Out = (float)BM1383_TempPressure / (float)2048;
                #endif
                pressureCurr += BM1383_Pres_Conv_Out;
            }
            #ifdef BM1383A
            i2c.write(Press_addr_w, &PWR_OFF[0], 2, false);
            i2c.write(Press_addr_w, &SLEEP_ON[0], 2, false);
            #endif
            pressureCurr = pressureCurr/10;
            
            HeightExtrapolated = ((pressureCurr * slope) + yInt)/12;
            //len = snprintf((char*) buf, MAX_REPLY_LEN, "Height=%f FT",HeightExtrapolated);
            //m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
            
            HeightExtrapolated_Foot = int(HeightExtrapolated);
            HeightExtrapolated_Inches = (HeightExtrapolated - HeightExtrapolated_Foot)* 12;
            len = snprintf((char*) buf, MAX_REPLY_LEN, "H=%.0fFT, %.0fIN",HeightExtrapolated_Foot,HeightExtrapolated_Inches);
        }
        
        else if(ReceivedValue.compare(0,2,"FT") == 0)
        {
            HeightKnown_Foot = (ReceivedValue[2]-48) * 12;  //Convert ASCII to INT, then Convert to Inches
            sprintf(FormattedData, "%2.0f", HeightKnown_Foot);
            len = snprintf((char*) buf, MAX_REPLY_LEN, "FT = %s inchs", FormattedData);
            wait_ms(200);
        }
        
        else if(ReceivedValue.compare(0,2,"IN") == 0)
        {
            if((ReceivedValue[3]>= 48) && (ReceivedValue[3]<=57)){
                HeightKnown_Inches = ((ReceivedValue[2]-48)*10) + (ReceivedValue[3]-48);    //Convert ASCII to INT, then Convert to Inches  
                
            }
            else{
                HeightKnown_Inches = (ReceivedValue[2]-48); //Convert ASCII to INT
            }
            sprintf(FormattedData, "%2.0f", HeightKnown_Inches);
            len = snprintf((char*) buf, MAX_REPLY_LEN, "IN = %s inchs", FormattedData);
            wait_ms(200);
        }
        
        else
        {
            len = snprintf((char*) buf, MAX_REPLY_LEN, "??? = %s", ReceivedValue.c_str());
            //m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
        } 
    }
    else
    {
        len = snprintf((char*) buf, MAX_REPLY_LEN, "ERR:NUL");
    }
    m_ble.updateCharacteristicValue(m_uart_service_ptr->getRXCharacteristicHandle(), buf, len);
    */
}