/* #####################################################################
                               SD20.cpp
                               --------
                
                          Surface Ship, Group 5
                          ---------------------
 
 Written by:        Steven Kay
 
 Date:              February 2016
 
 Function:          This 
 
 Version:           1.0
 
 Version History
 ---------------
 
 1.1                rgdfgdfgdfggdfgdg
 
 1.0                gdgddfdddgd
    
 ##################################################################### */

#include "mbed.h"
#include "SD20.h"
      
SD20::SD20(I2C *bus)
{
    _bus = bus;
    _bus -> frequency(BUS_FREQ);
}

int SD20::UpdateChannel(char channelReg, char channelSpeed)
{
        // Output new duty cycle to SD20, return 0 if successful, 1 if unsuccessful
        updateDutyCycle[0] = channelReg;
        updateDutyCycle[1] = channelSpeed;
        
        if(_bus -> write(SD20_ADDRESS,updateDutyCycle,2))
        {
//            printf("I2C Failed to write\r\n");
            return 1;
        }
        else
        {
//            updateDutyCycle = *(updateDutyCycle+1)
            printf("Reg: 0x%02x Data: 0x%02x\r\n",*updateDutyCycle,*(updateDutyCycle+1));
            return 0;
        }
}

int SD20::StartStopChannel(uint8_t ServoChannel,bool Start)
{
        // Startup a new channel, return 0 if successful, 1 if unsuccessful
        if(Start == CHANNEL_START)
        {
            char startDutyCycle[] = {ServoChannel,CHANNEL_START};
            if(_bus -> write(SD20_ADDRESS,startDutyCycle,OUT_BUF_LEN))
            {
//                printf("I2C Failed to write\r\n");
                return 1;
            }
            else
            {
//                printf("Reg: 0x%02x Data: 0x%02x\r\n",*newDutyCycle,*(newDutyCycle+1));
                return 0;
            }
        }
        
        // Stop channel, return 0 if successful, 1 if unsuccessful
        else
        {
           char stopDutyCycle[] = {ServoChannel,CHANNEL_STOP};
            if(_bus -> write(SD20_ADDRESS,stopDutyCycle,OUT_BUF_LEN))
            {
//                printf("I2C Failed to write\r\n");
                return 1;
            }
            else
            {
//                printf("Reg: 0x%02x Data: 0x%02x\r\n",*newDutyCycle,*(newDutyCycle+1));
                return 0;
            }
        }
}

int SD20::SetStandardMode()
{
        char outputBuf[] = {STD_ETD_MODE_CTRL,STD_MODE};
        if(_bus -> write(SD20_ADDRESS,outputBuf,OUT_BUF_LEN))
        {
//            printf("I2C Failed to write\r\n");
            return 1;
        }
        else
        {
//            printf("0x%02x sent to Reg: 0x%02x\r\n",*(outputBuf+1),*outputBuf);
            return 0;
        }    
}

