/* #####################################################################
                               SD20.h
                               ------
                
                          Surface Ship, Group 5
                          ---------------------
 
 Written by:        Steven Kay
 
 Date:              February 2016
 
 Function:          This 
 
 Version:           1.0
 
 Version History
 ---------------
 
 1.1                rgdfgdfgdfggdfgdg
 
 1.0                gdgddfdddgd
    
 ##################################################################### */

#ifndef SD20_H
#define SD20_H

/* I2C Parameters*/

// SD20 I2C Address
#define SD20_ADDRESS 0xC2

// SCL Frequency
#define BUS_FREQ 100000

// Output Buffer Length
#define OUT_BUF_LEN 2

/* SD20 Internal Register Map */
#define SOFTWARE_REVISION_REG 0x00
#define SERVO_1_REG 0x01
#define SERVO_2_REG 0x02
#define SERVO_3_REG 0x03
#define SERVO_4_REG 0x04
#define SERVO_5_REG 0x05
#define SERVO_6_REG 0x06
#define SERVO_7_REG 0x07
#define SERVO_8_REG 0x08
#define SERVO_9_REG 0x09
#define SERVO_10_REG 0x10
#define SERVO_11_REG 0x11
#define SERVO_12_REG 0x12
#define SERVO_13_REG 0x13
#define SERVO_14_REG 0x14
#define SERVO_15_REG 0x15
#define SERVO_16_REG 0x16
#define SERVO_17_REG 0x17
#define SERVO_18_REG 0x18
#define SERVO_19_REG 0x19
#define SERVO_20_REG 0x20
#define STD_ETD_MODE_CTRL 0x21
#define ETD_MODE_OFST_HIGH 0x22
#define ETD_MODE_OFST_LOW 0x23

/* SD20 Channel constants*/
#define CHANNEL_1 1
#define CHANNEL_2 2
#define CHANNEL_3 3
#define CHANNEL_4 4
#define CHANNEL_5 5
#define CHANNEL_6 6
#define CHANNEL_7 7
#define CHANNEL_8 8
#define CHANNEL_9 9
#define CHANNEL_10 10
#define CHANNEL_11 11
#define CHANNEL_12 12
#define CHANNEL_13 13
#define CHANNEL_14 14
#define CHANNEL_15 15
#define CHANNEL_16 16
#define CHANNEL_17 17
#define CHANNEL_18 18
#define CHANNEL_19 19
#define CHANNEL_20 20

#define CHANNEL_STOP 0x00
#define CHANNEL_START 0x01

#define STD_MODE 0x00

class SD20
{

private:
    I2C *_bus;
    
    char updateDutyCycle[2];
public:

    /** Create a SD20 Constructor, connected over I2C Master connection
     *  
     *  parameter bus:     I2C object
     */
    SD20(I2C *bus);

    /**
     *  Start/Stop PWM output on specificed channel (Standard mode)
     *
     *  parameter Channel:      Servo Channel to be stopped
     *  parameter Start:        Select whether to start[1] or stop [0] a given channel
     *  parameter mode:         Select whether debug mode[0] and prints result or implementation mode [1] 
     *                          where print commands are skipped to save operational time
     */
    int StartStopChannel(uint8_t ServoChannel, bool Start);

    /**
     *  Update PWM output on specificed channel (Standard mode)
     *
     *  parameter DataOutput:   Structured as follows: [Servo Channel[1:20], Pulse Width[0x00:0xFF]]
     *  parameter mode:         Select whether debug mode[0] and prints result or implementation mode [1] 
     *                          where print commands are skipped to save operational time
     */
    int UpdateChannel(char channelReg, char channelSpeed);


    int SetStandardMode();
};

#endif