#include "mbed.h"
#include "MCP9803.h"

////F446RE Board
//MCP9803 TempSensor(PB_9,PB_8,0x90,100000);

//F042K6 Board
MCP9803 TempSensor(PB_7,PB_6,0x90,100000);

int main()
{
    // Example of how to Configure Sensor
    
    int configSuccess = TempSensor.ConfigSensor(0x00,0x01,0x00,0x02,0x03,0x00);
    
    // Print value returned from ConfigSensor
    // 0 indicates success, 1 indicates failure
    printf("CONFIG Success = %d\r\n\r\n",configSuccess);
    
    // Print raw temp value
    // Anything other than 0x0FF0 indicates success
    printf("Temp Raw = %04x\r\n",TempSensor.RawTempValue());
    
    // Print converted temp values
    // Anything other than -2000.000 indicates success
    printf("Temp C = %f\r\n",TempSensor.FormattedTempValue(CELCIUS));
    printf("Temp F = %f\r\n",TempSensor.FormattedTempValue(FARENHEIT));
    printf("Temp K = %f\r\n",TempSensor.FormattedTempValue(KELVIN));
   
   // Example of failure from sending wrong format
   printf("Temp ? = %f\r\n",TempSensor.FormattedTempValue(0x0F));
}